/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.storage;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;

public abstract class DebuggerSetting<T> {
    private final IDebugger debugger;
    private final DebugTargetSettings debugTargetSettings;

    public DebuggerSetting(IDebugger debugger, DebugTargetSettings debugTarget) {
        this.debugger = debugger;
        this.debugTargetSettings = debugTarget;
    }

    private String getUniqueKey(String keySuffix) {
        int n2 = this.debugger.getId();
        return new StringBuilder(16 + String.valueOf(keySuffix).length()).append("dbg_").append(n2).append("_").append(keySuffix).toString();
    }

    protected boolean readBoolSetting(String key) throws CouldntLoadDataException {
        return Boolean.parseBoolean(this.readSetting(key));
    }

    protected String readSetting(String key) throws CouldntLoadDataException {
        return this.debugTargetSettings.readSetting(this.getUniqueKey(key));
    }

    protected void writeBoolSetting(String key, boolean value) throws CouldntSaveDataException {
        this.writeSetting(key, Boolean.toString(value));
    }

    protected void writeSetting(String key, String value) throws CouldntSaveDataException {
        this.debugTargetSettings.writeSetting(this.getUniqueKey(key), value);
    }

    public abstract T deserialize() throws CouldntLoadDataException;

    public abstract void serialize(T var1) throws CouldntSaveDataException;
}

