/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.processmanager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.List;

public final class TargetProcessThread {
    private final ListenerProvider<ThreadListener> listeners = new ListenerProvider();
    private final long threadId;
    private RelocatedAddress relocatedAddress;
    private ImmutableList<RegisterValue> registerValues = ImmutableList.builder().build();
    private ThreadState threadState = ThreadState.RUNNING;

    public TargetProcessThread(long tid, ThreadState state) {
        this.threadState = Preconditions.checkNotNull(state, "IE00823: Invalid state");
        this.threadId = tid;
    }

    public void addListener(ThreadListener listener) {
        this.listeners.addListener(listener);
    }

    public RelocatedAddress getCurrentAddress() {
        return this.relocatedAddress;
    }

    public ImmutableList<RegisterValue> getRegisterValues() {
        return ImmutableList.copyOf(this.registerValues);
    }

    public ThreadState getState() {
        return this.threadState;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void removeListener(ThreadListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setCurrentAddress(RelocatedAddress address) {
        Preconditions.checkNotNull(address, "IE00763: Address argument can not be null");
        RelocatedAddress oldAddress = this.relocatedAddress;
        this.relocatedAddress = address;
        for (ThreadListener listener : this.listeners) {
            try {
                listener.instructionPointerChanged(this, oldAddress);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setRegisterValues(List<RegisterValue> registerValues) {
        Preconditions.checkNotNull(registerValues, "IE00764: Register values argument can not be null");
        this.registerValues = ImmutableList.copyOf(registerValues);
        for (ThreadListener listener : this.listeners) {
            try {
                listener.registersChanged(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setState(ThreadState state) {
        Preconditions.checkNotNull(state, "IE00765: Thread state can not be null");
        if (this.threadState == state) {
            return;
        }
        if (state == ThreadState.RUNNING) {
            this.relocatedAddress = null;
        }
        this.threadState = state;
        for (ThreadListener listener : this.listeners) {
            try {
                listener.stateChanged(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

