/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.memoryexpressions;

import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpressionElement;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MinusExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MultiplicationExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.NumericalValue;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.PlusExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.Register;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.SubExpression;
import com.google.security.zynamics.binnavi.parsers.gotomem.MemoryExpressionLexer;
import com.google.security.zynamics.binnavi.parsers.gotomem.MemoryExpressionParser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;

public final class DebuggerMemoryExpressionParser {
    private static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        @Override
        public Object create(Token payload) {
            return new CommonTree(payload);
        }
    };

    private DebuggerMemoryExpressionParser() {
    }

    private static MemoryExpressionElement convert(CommonTree ast2) {
        if (ast2.getType() == 14) {
            return new Register(ast2.getText());
        }
        if (ast2.getType() == 12) {
            return new NumericalValue(new BigInteger(ast2.getText()));
        }
        if (ast2.getType() == 13) {
            return new NumericalValue(new BigInteger(ast2.getText().substring(2), 16));
        }
        if (ast2.getType() == 7) {
            return new MemoryExpression(DebuggerMemoryExpressionParser.convert((CommonTree)ast2.getChild(0)));
        }
        if (ast2.getType() == 15) {
            return new PlusExpression(DebuggerMemoryExpressionParser.convertChildren(ast2));
        }
        if (ast2.getType() == 16) {
            return new MinusExpression(DebuggerMemoryExpressionParser.convertChildren(ast2));
        }
        if (ast2.getType() == 17) {
            return new MultiplicationExpression(DebuggerMemoryExpressionParser.convertChildren(ast2));
        }
        if (ast2.getType() == 8) {
            return new SubExpression(DebuggerMemoryExpressionParser.convert((CommonTree)ast2.getChild(0)));
        }
        if (ast2.getType() == 0) {
            return DebuggerMemoryExpressionParser.convert((CommonTree)ast2.getChild(0));
        }
        int n2 = ast2.getType();
        throw new IllegalStateException(new StringBuilder(42).append("IE00360: Not yet implemented (").append(n2).append(")").toString());
    }

    private static List<MemoryExpressionElement> convertChildren(CommonTree ast2) {
        ArrayList<MemoryExpressionElement> children = new ArrayList<MemoryExpressionElement>();
        for (Object childObject : ast2.getChildren()) {
            children.add(DebuggerMemoryExpressionParser.convert((CommonTree)childObject));
        }
        return children;
    }

    public static MemoryExpressionElement parse(String memoryExpression) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(memoryExpression);
        MemoryExpressionLexer lexer = new MemoryExpressionLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream();
        tokens.setTokenSource(lexer);
        MemoryExpressionParser parser2 = new MemoryExpressionParser(tokens){

            @Override
            public void recover(IntStream input, RecognitionException exception) {
            }

            @Override
            public Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
                throw new MismatchedTokenException(ttype, input);
            }

            @Override
            public void reportError(RecognitionException exception) {
            }
        };
        parser2.setTreeAdaptor(adaptor);
        MemoryExpressionParser.prog_return parserResult = parser2.prog();
        CommonTree ast2 = (CommonTree)parserResult.getTree();
        return DebuggerMemoryExpressionParser.convert(ast2);
    }
}

