/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.breakpoints;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointStorage;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DefaultBreakpointStorage
implements BreakpointStorage {
    private final Map<BreakpointAddress, Breakpoint> breakpointAddressToBreakpoint = new HashMap<BreakpointAddress, Breakpoint>();
    private final Map<BreakpointAddress, BreakpointStatus> breakpointAddressToStatus = new HashMap<BreakpointAddress, BreakpointStatus>();
    private final SetMultimap<INaviModule, Breakpoint> moduleToBreakpoint = HashMultimap.create();

    DefaultBreakpointStorage() {
    }

    @Override
    public void add(Breakpoint breakpoint, BreakpointStatus status) {
        this.moduleToBreakpoint.put(breakpoint.getAddress().getModule(), breakpoint);
        this.breakpointAddressToBreakpoint.put(breakpoint.getAddress(), breakpoint);
        this.breakpointAddressToStatus.put(breakpoint.getAddress(), status);
    }

    @Override
    public void clear() {
        this.moduleToBreakpoint.clear();
        this.breakpointAddressToBreakpoint.clear();
        this.breakpointAddressToStatus.clear();
    }

    @Override
    public Breakpoint get(BreakpointAddress address) {
        return this.breakpointAddressToBreakpoint.get(address);
    }

    @Override
    public Set<BreakpointAddress> getBreakPointAddresses() {
        return this.breakpointAddressToBreakpoint.keySet();
    }

    @Override
    public Iterable<Breakpoint> getBreakpoints() {
        return this.moduleToBreakpoint.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(this.moduleToBreakpoint.values());
    }

    @Override
    public Set<Breakpoint> getBreakPointsByAddress(Set<BreakpointAddress> addresses) {
        HashSet<Breakpoint> breakpoints = new HashSet<Breakpoint>();
        for (BreakpointAddress breakpointAddress : addresses) {
            Breakpoint breakpoint = this.breakpointAddressToBreakpoint.get(breakpointAddress);
            if (breakpoint == null) continue;
            breakpoints.add(this.breakpointAddressToBreakpoint.get(breakpointAddress));
        }
        return breakpoints;
    }

    @Override
    public BreakpointStatus getBreakpointStatus(BreakpointAddress address) {
        return this.breakpointAddressToStatus.get(address);
    }

    @Override
    public Set<Breakpoint> getByModule(MemoryModule module) {
        for (INaviModule naviModule : this.moduleToBreakpoint.keySet()) {
            if (!naviModule.getConfiguration().getName().equalsIgnoreCase(module.getName())) continue;
            return this.moduleToBreakpoint.get(naviModule);
        }
        return new HashSet<Breakpoint>();
    }

    @Override
    public void remove(Breakpoint breakpoint) {
        this.moduleToBreakpoint.get(breakpoint.getAddress().getModule()).remove(breakpoint);
        this.breakpointAddressToBreakpoint.remove(breakpoint.getAddress());
        this.breakpointAddressToStatus.remove(breakpoint.getAddress());
    }

    @Override
    public void removeBreakpoints(Set<BreakpointAddress> addresses) {
        for (BreakpointAddress breakpointAddres : addresses) {
            Breakpoint breakpoint = this.breakpointAddressToBreakpoint.remove(breakpointAddres);
            this.moduleToBreakpoint.get(breakpointAddres.getModule()).remove(breakpoint);
            this.breakpointAddressToStatus.remove(breakpointAddres);
        }
    }

    @Override
    public void setBreakpointStatus(BreakpointAddress address, BreakpointStatus status) {
        if (this.breakpointAddressToBreakpoint.get(address) != null) {
            this.breakpointAddressToStatus.put(address, status);
        }
    }

    @Override
    public int size() {
        return this.moduleToBreakpoint.values().size();
    }

    @Override
    public int sizeByModuleFilter(IFilledList<MemoryModule> memoryModules) {
        int size = 0;
        for (MemoryModule memoryModule : memoryModules) {
            for (INaviModule naviModule : this.moduleToBreakpoint.keySet()) {
                if (!naviModule.getConfiguration().getName().equalsIgnoreCase(memoryModule.getName())) continue;
                size += this.moduleToBreakpoint.get(naviModule).size();
            }
        }
        return size;
    }
}

