/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.breakpoints;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointConditionParser;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.DefaultBreakpointStorage;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.InvalidFormulaException;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.RegularBreakpointStorage;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointStorage;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.IndexedBreakpointStorage;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class BreakpointManager {
    private final BreakpointStorage echoBreakpointStorage = new DefaultBreakpointStorage();
    private final BreakpointStorage stepBreakpointStorage = new DefaultBreakpointStorage();
    private final IndexedBreakpointStorage indexedBreakpointStorage = new RegularBreakpointStorage();
    private final ListenerProvider<BreakpointManagerListener> listeners = new ListenerProvider();

    private void addBreakpoints(Set<BreakpointAddress> addresses, BreakpointStatus status, BreakpointStorage storage, BreakpointType type) {
        Preconditions.checkNotNull(addresses, "IE00718: addresses argument can not be null");
        Preconditions.checkNotNull(status, "IE00719: status argument can not be null");
        Preconditions.checkNotNull(storage, "IE00720: storage argument can not be null");
        Preconditions.checkNotNull(type, "IE00721: type argument can not be null");
        if (addresses.size() == 0) {
            return;
        }
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        for (BreakpointAddress address : addresses) {
            Breakpoint breakpoint = new Breakpoint(type, address);
            storage.add(breakpoint, status);
            breakpoints.add(breakpoint);
        }
        for (BreakpointManagerListener listener : this.listeners) {
            try {
                listener.breakpointsAdded(breakpoints);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    private void checkArguments(BreakpointType type, BreakpointAddress address) {
        Preconditions.checkNotNull(type, "IE01012: Type argument can not be null");
        Preconditions.checkNotNull(address, "IE01022: Address argument can not be null");
    }

    private Set<BreakpointAddress> enforceBreakpointHierarchy(Set<BreakpointAddress> addresses, BreakpointType type) {
        Sets.SetView<BreakpointAddress> alreadyRegularBreakpoints = Sets.intersection(addresses, this.indexedBreakpointStorage.getBreakPointAddresses());
        Sets.SetView<BreakpointAddress> alreadySteppingBreakpoints = Sets.intersection(addresses, this.stepBreakpointStorage.getBreakPointAddresses());
        Sets.SetView<BreakpointAddress> alreadyEchoBreakpoints = Sets.intersection(addresses, this.echoBreakpointStorage.getBreakPointAddresses());
        Sets.SetView<BreakpointAddress> addressesSet = null;
        switch (type) {
            case REGULAR: {
                Sets.SetView<BreakpointAddress> notInRegularBreakpoints = Sets.difference(addresses, this.indexedBreakpointStorage.getBreakPointAddresses());
                this.removeBreakpoints(alreadySteppingBreakpoints, this.stepBreakpointStorage);
                this.removeBreakpoints(alreadyEchoBreakpoints, this.echoBreakpointStorage);
                addressesSet = notInRegularBreakpoints;
                break;
            }
            case STEP: {
                Sets.SetView<BreakpointAddress> notInSteppingBreakpoints = Sets.difference(addresses, this.stepBreakpointStorage.getBreakPointAddresses());
                this.removeBreakpoints(alreadyEchoBreakpoints, this.echoBreakpointStorage);
                addressesSet = Sets.difference(notInSteppingBreakpoints, alreadyRegularBreakpoints);
                break;
            }
            case ECHO: {
                Sets.SetView<BreakpointAddress> notInEchoBreakPoints = Sets.difference(addresses, this.echoBreakpointStorage.getBreakPointAddresses());
                addressesSet = Sets.difference(notInEchoBreakPoints, Sets.union(alreadySteppingBreakpoints, alreadyRegularBreakpoints));
                break;
            }
            default: {
                throw new IllegalStateException("IE00722: Breakpoint of invalid type");
            }
        }
        return addressesSet;
    }

    private void removeBreakpoints(Set<BreakpointAddress> breakpointAddressSet, BreakpointStorage storage) {
        if (breakpointAddressSet.size() != 0) {
            Set<Breakpoint> breakpoints = storage.getBreakPointsByAddress(breakpointAddressSet);
            storage.removeBreakpoints(breakpointAddressSet);
            for (BreakpointManagerListener listener : this.listeners) {
                try {
                    listener.breakpointsRemoved(breakpoints);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }
    }

    private void setBreakpointsStatus(Set<BreakpointAddress> addresses, BreakpointStatus newStatus, BreakpointStorage storage) {
        if (storage.getBreakPointsByAddress(addresses).isEmpty()) {
            return;
        }
        HashMap<Breakpoint, BreakpointStatus> breakpointToStatus = Maps.newHashMap();
        for (BreakpointAddress breakpointAddress : addresses) {
            breakpointToStatus.put(storage.get(breakpointAddress), storage.getBreakpointStatus(breakpointAddress));
            storage.setBreakpointStatus(breakpointAddress, newStatus);
        }
        for (BreakpointManagerListener listener : this.listeners) {
            try {
                listener.breakpointsStatusChanged(breakpointToStatus, newStatus);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setBreakpointCondition(int breakpointIndex, String formula) {
        Preconditions.checkNotNull(formula, "Error: formula argument can not be null.");
        Breakpoint breakpoint = this.getBreakpoint(BreakpointType.REGULAR, breakpointIndex);
        HashSet<Breakpoint> conditinalBreakPoints = Sets.newHashSet();
        Condition condition = null;
        try {
            condition = BreakpointConditionParser.evaluate(formula);
        }
        catch (InvalidFormulaException exception) {
            CUtilityFunctions.logException(exception);
        }
        breakpoint.setCondition(condition);
        conditinalBreakPoints.add(breakpoint);
        for (BreakpointManagerListener listener : this.listeners) {
            try {
                listener.breakpointsConditionChanged(conditinalBreakPoints);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addBreakpoints(BreakpointType type, Set<BreakpointAddress> addresses) {
        if (addresses.size() == 0) {
            return;
        }
        switch (type) {
            case REGULAR: {
                this.addBreakpoints(this.enforceBreakpointHierarchy(addresses, type), BreakpointStatus.BREAKPOINT_INACTIVE, this.indexedBreakpointStorage, type);
                break;
            }
            case ECHO: {
                this.addBreakpoints(this.enforceBreakpointHierarchy(addresses, type), BreakpointStatus.BREAKPOINT_ENABLED, this.echoBreakpointStorage, type);
                break;
            }
            case STEP: {
                this.addBreakpoints(this.enforceBreakpointHierarchy(addresses, type), BreakpointStatus.BREAKPOINT_INACTIVE, this.stepBreakpointStorage, type);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Invalid breakpoint type '%s'", new Object[]{type}));
            }
        }
    }

    public void addListener(BreakpointManagerListener listener) {
        this.listeners.addListener(Preconditions.checkNotNull(listener, "IE00723: listener argument can not be null"));
    }

    public void clearBreakpointsPassive(BreakpointType type) {
        Preconditions.checkNotNull(type, "IE01011: Type argument can not be null");
        NaviLogger.info("Clearing all breakpoints of type '%s' passively", new Object[]{type});
        switch (type) {
            case REGULAR: {
                throw new IllegalStateException("IE01018: Regular breakpoints can not be cleared passively");
            }
            case ECHO: {
                this.echoBreakpointStorage.clear();
                return;
            }
            case STEP: {
                this.stepBreakpointStorage.clear();
                return;
            }
        }
        throw new IllegalStateException(String.format("IE01017: Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public Breakpoint getBreakpoint(BreakpointType type, BreakpointAddress address) {
        this.checkArguments(type, address);
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.get(address);
            }
            case ECHO: {
                return this.echoBreakpointStorage.get(address);
            }
            case STEP: {
                return this.stepBreakpointStorage.get(address);
            }
        }
        throw new IllegalStateException(String.format("IE01008: Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public Breakpoint getBreakpoint(BreakpointType type, int index) {
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.get(index);
            }
        }
        throw new IllegalStateException(String.format("IE01019: Invalid breakpoint type '%s' for indexed breakpoint access", new Object[]{type}));
    }

    public Iterable<Breakpoint> getBreakpoints(BreakpointType type) {
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.getBreakpoints();
            }
            case ECHO: {
                return this.echoBreakpointStorage.getBreakpoints();
            }
            case STEP: {
                return this.stepBreakpointStorage.getBreakpoints();
            }
        }
        throw new IllegalStateException(String.format("Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public Set<Breakpoint> getBreakpointsByModule(BreakpointType type, MemoryModule module) {
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.getByModule(module);
            }
            case ECHO: {
                return this.echoBreakpointStorage.getByModule(module);
            }
            case STEP: {
                return this.stepBreakpointStorage.getByModule(module);
            }
        }
        throw new IllegalStateException(String.format("IE00725: Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public BreakpointStatus getBreakpointStatus(BreakpointType type, int index) {
        switch (type) {
            case REGULAR: {
                return this.getBreakpointStatus(this.indexedBreakpointStorage.get(index).getAddress(), type);
            }
        }
        String string2 = String.valueOf(type.toString());
        throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string2).length()).append("IE00724: Invalid breakpoint type ").append(string2).append(" for indexed breakpoint access").toString());
    }

    public BreakpointStatus getBreakpointStatus(BreakpointAddress address, BreakpointType type) {
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.getBreakpointStatus(address);
            }
            case ECHO: {
                return this.echoBreakpointStorage.getBreakpointStatus(address);
            }
            case STEP: {
                return this.stepBreakpointStorage.getBreakpointStatus(address);
            }
        }
        throw new IllegalStateException("IE00726: Invalid Breakpoint Type");
    }

    public int getNumberOfBreakpoints(BreakpointType type) {
        Preconditions.checkNotNull(type, "IE01013: Type argument can not be null");
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.size();
            }
            case ECHO: {
                return this.echoBreakpointStorage.size();
            }
            case STEP: {
                return this.stepBreakpointStorage.size();
            }
        }
        throw new IllegalStateException(String.format("IE01014: Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public int getNumberOfBreakpoints(BreakpointType type, IFilledList<MemoryModule> memoryModules) {
        Preconditions.checkNotNull(type, "IE00175: Type argument can not be null");
        Preconditions.checkNotNull(memoryModules, "IE00177: Memory Modules argument can not be null");
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.sizeByModuleFilter(memoryModules);
            }
            case ECHO: {
                return this.echoBreakpointStorage.sizeByModuleFilter(memoryModules);
            }
            case STEP: {
                return this.stepBreakpointStorage.sizeByModuleFilter(memoryModules);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public boolean hasBreakpoint(BreakpointType type, BreakpointAddress address) {
        this.checkArguments(type, address);
        switch (type) {
            case REGULAR: {
                return this.indexedBreakpointStorage.get(address) != null;
            }
            case ECHO: {
                return this.echoBreakpointStorage.get(address) != null;
            }
            case STEP: {
                return this.stepBreakpointStorage.get(address) != null;
            }
        }
        throw new IllegalStateException(String.format("IE01007: Invalid breakpoint type '%s'", new Object[]{type}));
    }

    public void removeBreakpoints(BreakpointType type, Set<BreakpointAddress> breakpoints) {
        Preconditions.checkNotNull(type, "IE00178: Type argument can not be null");
        Preconditions.checkNotNull(breakpoints, "IE00179: breakpoints argument can not be null");
        if (breakpoints.size() == 0) {
            return;
        }
        switch (type) {
            case REGULAR: {
                this.removeBreakpoints(breakpoints, this.indexedBreakpointStorage);
                break;
            }
            case ECHO: {
                this.removeBreakpoints(breakpoints, this.echoBreakpointStorage);
                break;
            }
            case STEP: {
                this.removeBreakpoints(breakpoints, this.stepBreakpointStorage);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Invalid breakpoint type '%s'", new Object[]{type}));
            }
        }
    }

    public void removeBreakpointsPassive(BreakpointType type, Set<BreakpointAddress> addresses) {
        if (addresses.size() == 0) {
            return;
        }
        switch (type) {
            case REGULAR: {
                this.indexedBreakpointStorage.removeBreakpoints(addresses);
                break;
            }
            case ECHO: {
                this.echoBreakpointStorage.removeBreakpoints(addresses);
                break;
            }
            case STEP: {
                this.stepBreakpointStorage.removeBreakpoints(addresses);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("IE01008: Invalid breakpoint type '%s'", new Object[]{type}));
            }
        }
    }

    public void removeListener(BreakpointManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setBreakpointStatus(BreakpointType type, BreakpointStatus newStatus, int index) {
        switch (type) {
            case REGULAR: {
                this.setBreakpointsStatus(Sets.newHashSet(this.indexedBreakpointStorage.get(index).getAddress()), newStatus, this.indexedBreakpointStorage);
                break;
            }
            default: {
                String string2 = String.valueOf((Object)type);
                throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string2).length()).append("IE00727: Invalid breakpoint type ").append(string2).append(" for indexed breakpoint access").toString());
            }
        }
    }

    public void setBreakpointStatus(Set<BreakpointAddress> addresses, BreakpointType type, BreakpointStatus newStatus) {
        if (addresses.size() == 0) {
            return;
        }
        switch (type) {
            case REGULAR: {
                this.setBreakpointsStatus(addresses, newStatus, this.indexedBreakpointStorage);
                break;
            }
            case ECHO: {
                this.setBreakpointsStatus(addresses, newStatus, this.echoBreakpointStorage);
                break;
            }
            case STEP: {
                this.setBreakpointsStatus(addresses, newStatus, this.stepBreakpointStorage);
                break;
            }
            default: {
                throw new IllegalStateException("IE00728: Invalid Breakpoint Type");
            }
        }
    }

    public static Color getBreakpointColor(BreakpointStatus breakpointStatus) {
        switch (breakpointStatus) {
            case BREAKPOINT_ACTIVE: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointActive();
            }
            case BREAKPOINT_INACTIVE: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointInactive();
            }
            case BREAKPOINT_ENABLED: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointEnabled();
            }
            case BREAKPOINT_DISABLED: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointDisabled();
            }
            case BREAKPOINT_HIT: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointHit();
            }
            case BREAKPOINT_INVALID: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointInvalid();
            }
            case BREAKPOINT_DELETING: {
                return ConfigManager.instance().getDebuggerColorSettings().getBreakpointDeleting();
            }
        }
        throw new IllegalStateException("IE01182: Unknown breakpoint status");
    }
}

