/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.breakpoints;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointCondition;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.InvalidFormulaException;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.ConditionNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.ExpressionNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.FormulaNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.IdentifierNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.MemoryNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.NumberNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.RelationNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.SubNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.binnavi.parsers.BreakpointCondition.ConditionLexer;
import com.google.security.zynamics.binnavi.parsers.BreakpointCondition.ConditionParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;

public final class BreakpointConditionParser {
    private static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        @Override
        public Object create(Token payload) {
            return new CommonTree(payload);
        }
    };

    private BreakpointConditionParser() {
    }

    private static ConditionNode convert(CommonTree ast2) throws RecognitionException {
        if (ast2 == null) {
            throw new RecognitionException();
        }
        switch (ast2.getType()) {
            case 0: {
                return BreakpointConditionParser.convert((CommonTree)ast2.getChild(0));
            }
            case 4: {
                return new SubNode(BreakpointConditionParser.convert((CommonTree)ast2.getChild(0)));
            }
            case 5: {
                return new MemoryNode(BreakpointConditionParser.convert((CommonTree)ast2.getChild(0)));
            }
            case 9: {
                try {
                    return new NumberNode(Long.valueOf(ast2.getText()));
                }
                catch (NumberFormatException exception) {
                    throw new RecognitionException();
                }
            }
            case 10: {
                try {
                    return new NumberNode(Long.valueOf(ast2.getText().substring(2), 16));
                }
                catch (NumberFormatException exception) {
                    throw new RecognitionException();
                }
            }
            case 11: {
                return new IdentifierNode(ast2.getText());
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return new RelationNode(ast2.getText(), BreakpointConditionParser.convert((CommonTree)ast2.getChild(0)), BreakpointConditionParser.convert((CommonTree)ast2.getChild(1)));
            }
            case 19: 
            case 20: {
                return new ExpressionNode(ast2.getText(), BreakpointConditionParser.createOperator(ast2));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return new FormulaNode(ast2.getText(), BreakpointConditionParser.createOperator(ast2));
            }
        }
        int n2 = ast2.getType();
        throw new IllegalStateException(new StringBuilder(42).append("IE01140: Not yet implemented (").append(n2).append(")").toString());
    }

    private static List<ConditionNode> createOperator(CommonTree ast2) throws RecognitionException {
        ArrayList<ConditionNode> children = new ArrayList<ConditionNode>();
        for (Object child : ast2.getChildren()) {
            children.add(BreakpointConditionParser.convert((CommonTree)child));
        }
        return children;
    }

    public static Condition evaluate(String condition) throws InvalidFormulaException {
        try {
            return new BreakpointCondition(condition, BreakpointConditionParser.parse(condition));
        }
        catch (MaybeNullException e2) {
            return new BreakpointCondition(condition, null);
        }
        catch (RecognitionException e3) {
            throw new InvalidFormulaException();
        }
    }

    public static ConditionNode parse(String conditionString) throws RecognitionException, MaybeNullException {
        if (conditionString.trim().isEmpty()) {
            throw new MaybeNullException();
        }
        ANTLRStringStream charStream = new ANTLRStringStream(conditionString);
        ConditionLexer lexer = new ConditionLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream();
        tokens.setTokenSource(lexer);
        ConditionParser parser2 = new ConditionParser(tokens);
        parser2.setTreeAdaptor(adaptor);
        try {
            ConditionParser.prog_return parserResult = parser2.prog();
            CommonTree ast2 = (CommonTree)parserResult.getTree();
            if (parser2.input.index() < parser2.input.size()) {
                throw new RecognitionException();
            }
            return BreakpointConditionParser.convert(ast2);
        }
        catch (IllegalArgumentException e2) {
            throw new RecognitionException();
        }
    }
}

