/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.breakpoints;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;

public class BreakpointAddress {
    private final INaviModule module;
    private final UnrelocatedAddress unrelocatedBreakpointAddress;

    public BreakpointAddress(INaviModule module, UnrelocatedAddress address) {
        this.unrelocatedBreakpointAddress = Preconditions.checkNotNull(address, "IE00234: Address argument can not be null");
        this.module = Preconditions.checkNotNull(module, "IE01693: Module arguemnt can not be null");
    }

    public boolean equals(Object rhs) {
        return rhs instanceof BreakpointAddress && ((BreakpointAddress)rhs).module == this.module && ((BreakpointAddress)rhs).unrelocatedBreakpointAddress.equals(this.unrelocatedBreakpointAddress);
    }

    public UnrelocatedAddress getAddress() {
        return this.unrelocatedBreakpointAddress;
    }

    public INaviModule getModule() {
        return this.module;
    }

    public int hashCode() {
        return Objects.hashCode(this.unrelocatedBreakpointAddress.hashCode(), this.module.hashCode());
    }

    public String toString() {
        String string2 = String.valueOf(this.module);
        String string3 = String.valueOf(this.unrelocatedBreakpointAddress);
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("!").append(string3).toString();
    }
}

