/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.breakpoints;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;

public class Breakpoint {
    private final BreakpointType type;
    private final BreakpointAddress address;
    private String description;
    private Condition condition;

    public Breakpoint(BreakpointType type, BreakpointAddress address) {
        this.type = Preconditions.checkNotNull(type, "IE00196: type argument can not be null");
        this.address = Preconditions.checkNotNull(address, "IE00717: address argument can not be null");
    }

    public boolean equals(Object rhs) {
        return rhs instanceof Breakpoint && this.address.equals(((Breakpoint)rhs).getAddress()) && this.type.equals((Object)((Breakpoint)rhs).getType());
    }

    public BreakpointAddress getAddress() {
        return this.address;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getDescription() {
        return this.description;
    }

    public BreakpointType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(this.address.hashCode(), this.type.ordinal());
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

