/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadClosedReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ThreadClosedSynchronizer
extends ReplySynchronizer<ThreadClosedReply> {
    public ThreadClosedSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(ThreadClosedReply reply) {
        ProcessManager processManager = this.getDebugger().getProcessManager();
        long tid = reply.getThreadId();
        try {
            processManager.removeThread(processManager.getThread(tid));
        }
        catch (MaybeNullException e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ThreadClosedReply reply) {
        listener.receivedReply(reply);
    }
}

