/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SingleStepReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class SingleStepSynchronizer
extends ReplySynchronizer<SingleStepReply> {
    public SingleStepSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(SingleStepReply reply) {
        ProcessManager processManager = this.getDebugger().getProcessManager();
        long tid = reply.getThreadId();
        try {
            TargetProcessThread thread2 = processManager.getThread(tid);
            processManager.setActiveThread(thread2);
            this.setRegisterValues(reply.getRegisterValues());
            this.updateHitBreakpoints(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), thread2.getCurrentAddress()));
        }
        catch (MaybeNullException e2) {
            NaviLogger.info("Error: Process manager could not get thread. Exception %s", e2);
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, SingleStepReply reply) {
        listener.receivedReply(reply);
    }
}

