/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ResumeSynchronizer
extends ReplySynchronizer<ResumeReply> {
    public ResumeSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(ResumeReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        ProcessManager processManager = this.getDebugger().getProcessManager();
        for (Breakpoint breakpoint : manager.getBreakpoints(BreakpointType.REGULAR)) {
            if (manager.getBreakpointStatus(breakpoint.getAddress(), breakpoint.getType()) != BreakpointStatus.BREAKPOINT_HIT) continue;
            manager.setBreakpointStatus(Sets.newHashSet(breakpoint.getAddress()), breakpoint.getType(), BreakpointStatus.BREAKPOINT_ACTIVE);
        }
        processManager.setActiveThread(null);
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ResumeReply reply) {
        listener.receivedReply(reply);
    }
}

