/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CBreakpointModuleSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CRelocationNotifier;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessStartReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public class ProcessStartSynchronizer
extends ReplySynchronizer<ProcessStartReply> {
    public ProcessStartSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(ProcessStartReply reply) {
        TargetProcessThread thread2 = reply.getProcessStart().getThread();
        MemoryModule module = reply.getProcessStart().getModule();
        this.getDebugger().getProcessManager().addThread(thread2);
        this.getDebugger().getProcessManager().setActiveThread(thread2);
        this.refreshRegisters();
        CRelocationNotifier.relocateModule(this.getDebugger(), module);
        this.getDebugger().getProcessManager().addModule(module);
        CBreakpointModuleSynchronizer.enableRegularBreakpoints(this.getDebugger(), module);
        try {
            this.getDebugger().resume();
        }
        catch (DebugExceptionWrapper e2) {
            NaviLogger.severe("Error: Could not resume debugger. Exception: %s", e2);
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ProcessStartReply reply) {
        listener.receivedReply(reply);
    }
}

