/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.HaltReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class HaltSynchronizer
extends ReplySynchronizer<HaltReply> {
    public HaltSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(HaltReply reply) {
        ProcessManager processManager = this.getDebugger().getProcessManager();
        try {
            TargetProcessThread thread2 = processManager.getThread(reply.getTid());
            processManager.setActiveThread(thread2);
        }
        catch (MaybeNullException e2) {
            NaviLogger.severe("Error: Process manager could not set active threads. Exception %s", e2);
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, HaltReply reply) {
        listener.receivedReply(reply);
    }
}

