/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ExceptionOccurredReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class ExceptionOccurredSynchronizer
extends ReplySynchronizer<ExceptionOccurredReply> {
    public ExceptionOccurredSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(ExceptionOccurredReply reply) {
        ProcessManager processManager = this.getDebugger().getProcessManager();
        try {
            TargetProcessThread thread2 = processManager.getThread(reply.getThreadId());
            processManager.setActiveThread(thread2);
            thread2.setCurrentAddress(reply.getAddress());
            processManager.addExceptionEvent(new DebuggerException(reply.getExceptionName(), reply.getExceptionCode(), DebuggerExceptionHandlingAction.Continue));
            this.refreshRegisters();
        }
        catch (MaybeNullException exception) {
            NaviLogger.severe("Exception occured in unknown thread %d", reply.getThreadId());
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, ExceptionOccurredReply reply) {
        listener.receivedReply(reply);
    }
}

