/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.DebugEventListener;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AttachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AuthenticationFailedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointConditionSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.CancelTargetSelectionReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerClosedUnexpectedlyReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DetachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ExceptionOccurredReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.HaltReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListFilesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListProcessesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.MemoryMapReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleLoadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleUnloadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessStartReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.QueryDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ReadMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RegistersReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RequestTargetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SearchReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectFileReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectProcessReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetExceptionSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetRegisterReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SingleStepReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SuspendThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TargetInformationReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TerminateReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadCreatedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ValidateMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.WriteMemoryReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.AttachSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.AuthenticationFailedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.BreakpointConditionSetSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.BreakpointHitSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.BreakpointRemovedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.BreakpointSetSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.CancelTargetSelectionSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.DetachSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.EchoBreakpointHitSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.EchoBreakpointRemovedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.EchoBreakpointSetSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ErrorConnectionClosedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ExceptionOccurredSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.HaltSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ListFilesSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ListProcessesSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.MemoryMapSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ModuleLoadedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ModuleUnloadedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ProcessClosedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ProcessSelectedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ProcessStartSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.QueryDebuggerEventSettingsSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReadMemorySynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReadRegistersSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.RequestTargetSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ResumeSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ResumeThreadSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SearchSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SelectFileSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SetDebuggerEventSettingsSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SetExceptionSettingsSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SetRegisterSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SingleStepSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.StepBreakpointHitSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.StepBreakpointRemovedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.StepBreakpointSetSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.SuspendThreadSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.TargetInformationSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.TerminateSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ThreadClosedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ThreadCreatedSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ValidateMemorySynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.WriteMemorySynchronizer;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class DebuggerSynchronizer
implements DebugEventListener {
    private final ListenerProvider<IDebugEventListener> listeners = new ListenerProvider();
    private final AttachSynchronizer attachSynchronizer;
    private final BreakpointHitSynchronizer breakpointHitSynchronizer;
    private final BreakpointRemovedSynchronizer breakpointRemovedSynchronizer;
    private final BreakpointSetSynchronizer breakpointSetSynchronizer;
    private final DetachSynchronizer detachSynchronizer;
    private final EchoBreakpointHitSynchronizer echoBreakpointHitSynchronizer;
    private final EchoBreakpointRemovedSynchronizer echoBreakpointRemovedSynchronizer;
    private final EchoBreakpointSetSynchronizer echoBreakpointSetSynchronizer;
    private final ErrorConnectionClosedSynchronizer errorConnectionClosedSynchronizer;
    private final ExceptionOccurredSynchronizer exceptionOccurredSynchronizer;
    private final SelectFileSynchronizer fileSelectedSynchronizer;
    private final HaltSynchronizer haltSynchronizer;
    private final TargetInformationSynchronizer targetInformationSynchronizer;
    private final ListFilesSynchronizer listFilesSynchronizer;
    private final ListProcessesSynchronizer listProcessesSynchronizer;
    private final MemoryMapSynchronizer memoryMapSynchronizer;
    private final ModuleLoadedSynchronizer moduleLoadedSynchronizer;
    private final ModuleUnloadedSynchronizer moduleUnloadedSynchronizer;
    private final ProcessClosedSynchronizer processClosedSynchronizer;
    private final ProcessSelectedSynchronizer processSelectedSynchronizer;
    private final ReadMemorySynchronizer readMemorySynchronizer;
    private final ReadRegistersSynchronizer readRegistersSynchronizer;
    private final RequestTargetSynchronizer requestTargetSynchronizer;
    private final ResumeSynchronizer resumeSynchronizer;
    private final SearchSynchronizer searchSynchronizer;
    private final SetRegisterSynchronizer setRegisterSynchronizer;
    private final SingleStepSynchronizer singleStepSynchronizer;
    private final StepBreakpointHitSynchronizer stepBreakpointHitSynchronizer;
    private final StepBreakpointRemovedSynchronizer stepBreakpointRemovedSynchronizer;
    private final StepBreakpointSetSynchronizer stepBreakpointSetSynchronizer;
    private final TerminateSynchronizer terminateSynchronizer;
    private final ThreadClosedSynchronizer threadClosedSynchronizer;
    private final ThreadCreatedSynchronizer threadCreatedSynchronizer;
    private final ValidateMemorySynchronizer validateMemorySynchronizer;
    private final ResumeThreadSynchronizer resumeThreadSynchronizer;
    private final SuspendThreadSynchronizer suspendThreadSynchronizer;
    private final BreakpointConditionSetSynchronizer breakpointConditionSetSynchronizer;
    private final WriteMemorySynchronizer writeMemorySynchronizer;
    private final AuthenticationFailedSynchronizer authenticationFailedSynchronizer;
    private final QueryDebuggerEventSettingsSynchronizer queryDebuggerEventSettingsSynchronizer;
    private final SetExceptionSettingsSynchronizer setExceptionSettingsSynchronizer;
    private final ProcessStartSynchronizer processStartSynchronizer;
    private final SetDebuggerEventSettingsSynchronizer setDebuggerEventSettingsSynchronizer;
    private final CancelTargetSelectionSynchronizer cancelTargetSelectionSynchronizer;

    public DebuggerSynchronizer(IDebugger debugger) {
        Preconditions.checkNotNull(debugger, "IE00789: Debugger argument can not be null");
        this.attachSynchronizer = new AttachSynchronizer(debugger, this.listeners);
        this.breakpointHitSynchronizer = new BreakpointHitSynchronizer(debugger, this.listeners);
        this.breakpointRemovedSynchronizer = new BreakpointRemovedSynchronizer(debugger, this.listeners);
        this.breakpointSetSynchronizer = new BreakpointSetSynchronizer(debugger, this.listeners);
        this.detachSynchronizer = new DetachSynchronizer(debugger, this.listeners);
        this.echoBreakpointHitSynchronizer = new EchoBreakpointHitSynchronizer(debugger, this.listeners);
        this.echoBreakpointRemovedSynchronizer = new EchoBreakpointRemovedSynchronizer(debugger, this.listeners);
        this.echoBreakpointSetSynchronizer = new EchoBreakpointSetSynchronizer(debugger, this.listeners);
        this.errorConnectionClosedSynchronizer = new ErrorConnectionClosedSynchronizer(debugger, this.listeners);
        this.authenticationFailedSynchronizer = new AuthenticationFailedSynchronizer(debugger, this.listeners);
        this.exceptionOccurredSynchronizer = new ExceptionOccurredSynchronizer(debugger, this.listeners);
        this.fileSelectedSynchronizer = new SelectFileSynchronizer(debugger, this.listeners);
        this.haltSynchronizer = new HaltSynchronizer(debugger, this.listeners);
        this.targetInformationSynchronizer = new TargetInformationSynchronizer(debugger, this.listeners);
        this.listFilesSynchronizer = new ListFilesSynchronizer(debugger, this.listeners);
        this.listProcessesSynchronizer = new ListProcessesSynchronizer(debugger, this.listeners);
        this.memoryMapSynchronizer = new MemoryMapSynchronizer(debugger, this.listeners);
        this.moduleLoadedSynchronizer = new ModuleLoadedSynchronizer(debugger, this.listeners);
        this.moduleUnloadedSynchronizer = new ModuleUnloadedSynchronizer(debugger, this.listeners);
        this.processClosedSynchronizer = new ProcessClosedSynchronizer(debugger, this.listeners);
        this.processSelectedSynchronizer = new ProcessSelectedSynchronizer(debugger, this.listeners);
        this.readMemorySynchronizer = new ReadMemorySynchronizer(debugger, this.listeners);
        this.readRegistersSynchronizer = new ReadRegistersSynchronizer(debugger, this.listeners);
        this.requestTargetSynchronizer = new RequestTargetSynchronizer(debugger, this.listeners);
        this.resumeSynchronizer = new ResumeSynchronizer(debugger, this.listeners);
        this.searchSynchronizer = new SearchSynchronizer(debugger, this.listeners);
        this.setRegisterSynchronizer = new SetRegisterSynchronizer(debugger, this.listeners);
        this.singleStepSynchronizer = new SingleStepSynchronizer(debugger, this.listeners);
        this.stepBreakpointHitSynchronizer = new StepBreakpointHitSynchronizer(debugger, this.listeners);
        this.stepBreakpointRemovedSynchronizer = new StepBreakpointRemovedSynchronizer(debugger, this.listeners);
        this.stepBreakpointSetSynchronizer = new StepBreakpointSetSynchronizer(debugger, this.listeners);
        this.terminateSynchronizer = new TerminateSynchronizer(debugger, this.listeners);
        this.threadClosedSynchronizer = new ThreadClosedSynchronizer(debugger, this.listeners);
        this.threadCreatedSynchronizer = new ThreadCreatedSynchronizer(debugger, this.listeners);
        this.validateMemorySynchronizer = new ValidateMemorySynchronizer(debugger, this.listeners);
        this.resumeThreadSynchronizer = new ResumeThreadSynchronizer(debugger, this.listeners);
        this.suspendThreadSynchronizer = new SuspendThreadSynchronizer(debugger, this.listeners);
        this.breakpointConditionSetSynchronizer = new BreakpointConditionSetSynchronizer(debugger, this.listeners);
        this.writeMemorySynchronizer = new WriteMemorySynchronizer(debugger, this.listeners);
        this.queryDebuggerEventSettingsSynchronizer = new QueryDebuggerEventSettingsSynchronizer(debugger, this.listeners);
        this.setExceptionSettingsSynchronizer = new SetExceptionSettingsSynchronizer(debugger, this.listeners);
        this.processStartSynchronizer = new ProcessStartSynchronizer(debugger, this.listeners);
        this.setDebuggerEventSettingsSynchronizer = new SetDebuggerEventSettingsSynchronizer(debugger, this.listeners);
        this.cancelTargetSelectionSynchronizer = new CancelTargetSelectionSynchronizer(debugger, this.listeners);
    }

    public void addListener(IDebugEventListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void receivedEvent(DebuggerReply reply) {
        Preconditions.checkNotNull(reply, "IE01211: Debug event can't be null");
        if (reply instanceof AttachReply) {
            this.attachSynchronizer.handle((AttachReply)reply);
        } else if (reply instanceof BreakpointHitReply) {
            this.breakpointHitSynchronizer.handle((BreakpointHitReply)reply);
        } else if (reply instanceof BreakpointsRemovedReply) {
            this.breakpointRemovedSynchronizer.handle((BreakpointsRemovedReply)reply);
        } else if (reply instanceof BreakpointSetReply) {
            this.breakpointSetSynchronizer.handle((BreakpointSetReply)reply);
        } else if (reply instanceof CancelTargetSelectionReply) {
            this.cancelTargetSelectionSynchronizer.handle((CancelTargetSelectionReply)reply);
        } else if (reply instanceof AuthenticationFailedReply) {
            this.authenticationFailedSynchronizer.handle((AuthenticationFailedReply)reply);
        } else if (reply instanceof DebuggerClosedUnexpectedlyReply) {
            this.errorConnectionClosedSynchronizer.handle((DebuggerClosedUnexpectedlyReply)reply);
        } else if (reply instanceof DetachReply) {
            this.detachSynchronizer.handle((DetachReply)reply);
        } else if (reply instanceof EchoBreakpointHitReply) {
            this.echoBreakpointHitSynchronizer.handle((EchoBreakpointHitReply)reply);
        } else if (reply instanceof EchoBreakpointsRemovedReply) {
            this.echoBreakpointRemovedSynchronizer.handle((EchoBreakpointsRemovedReply)reply);
        } else if (reply instanceof EchoBreakpointSetReply) {
            this.echoBreakpointSetSynchronizer.handle((EchoBreakpointSetReply)reply);
        } else if (reply instanceof ExceptionOccurredReply) {
            this.exceptionOccurredSynchronizer.handle((ExceptionOccurredReply)reply);
        } else if (reply instanceof HaltReply) {
            this.haltSynchronizer.handle((HaltReply)reply);
        } else if (reply instanceof ListFilesReply) {
            this.listFilesSynchronizer.handle((ListFilesReply)reply);
        } else if (reply instanceof ListProcessesReply) {
            this.listProcessesSynchronizer.handle((ListProcessesReply)reply);
        } else if (reply instanceof MemoryMapReply) {
            this.memoryMapSynchronizer.handle((MemoryMapReply)reply);
        } else if (reply instanceof ModuleLoadedReply) {
            this.moduleLoadedSynchronizer.handle((ModuleLoadedReply)reply);
        } else if (reply instanceof ModuleUnloadedReply) {
            this.moduleUnloadedSynchronizer.handle((ModuleUnloadedReply)reply);
        } else if (reply instanceof ProcessClosedReply) {
            this.processClosedSynchronizer.handle((ProcessClosedReply)reply);
        } else if (reply instanceof ReadMemoryReply) {
            this.readMemorySynchronizer.handle((ReadMemoryReply)reply);
        } else if (reply instanceof RegistersReply) {
            this.readRegistersSynchronizer.handle((RegistersReply)reply);
        } else if (reply instanceof RequestTargetReply) {
            this.requestTargetSynchronizer.handle((RequestTargetReply)reply);
        } else if (reply instanceof ResumeReply) {
            this.resumeSynchronizer.handle((ResumeReply)reply);
        } else if (reply instanceof SearchReply) {
            this.searchSynchronizer.handle((SearchReply)reply);
        } else if (reply instanceof SelectFileReply) {
            this.fileSelectedSynchronizer.handle((SelectFileReply)reply);
        } else if (reply instanceof SelectProcessReply) {
            this.processSelectedSynchronizer.handle((SelectProcessReply)reply);
        } else if (reply instanceof SetRegisterReply) {
            this.setRegisterSynchronizer.handle((SetRegisterReply)reply);
        } else if (reply instanceof SingleStepReply) {
            this.singleStepSynchronizer.handle((SingleStepReply)reply);
        } else if (reply instanceof StepBreakpointHitReply) {
            this.stepBreakpointHitSynchronizer.handle((StepBreakpointHitReply)reply);
        } else if (reply instanceof StepBreakpointsRemovedReply) {
            this.stepBreakpointRemovedSynchronizer.handle((StepBreakpointsRemovedReply)reply);
        } else if (reply instanceof StepBreakpointSetReply) {
            this.stepBreakpointSetSynchronizer.handle((StepBreakpointSetReply)reply);
        } else if (reply instanceof TargetInformationReply) {
            this.targetInformationSynchronizer.handle((TargetInformationReply)reply);
        } else if (reply instanceof TerminateReply) {
            this.terminateSynchronizer.handle((TerminateReply)reply);
        } else if (reply instanceof ThreadClosedReply) {
            this.threadClosedSynchronizer.handle((ThreadClosedReply)reply);
        } else if (reply instanceof ThreadCreatedReply) {
            this.threadCreatedSynchronizer.handle((ThreadCreatedReply)reply);
        } else if (reply instanceof ValidateMemoryReply) {
            this.validateMemorySynchronizer.handle((ValidateMemoryReply)reply);
        } else if (reply instanceof ResumeThreadReply) {
            this.resumeThreadSynchronizer.handle((ResumeThreadReply)reply);
        } else if (reply instanceof SuspendThreadReply) {
            this.suspendThreadSynchronizer.handle((SuspendThreadReply)reply);
        } else if (reply instanceof BreakpointConditionSetReply) {
            this.breakpointConditionSetSynchronizer.handle((BreakpointConditionSetReply)reply);
        } else if (reply instanceof WriteMemoryReply) {
            this.writeMemorySynchronizer.handle((WriteMemoryReply)reply);
        } else if (reply instanceof QueryDebuggerEventSettingsReply) {
            this.queryDebuggerEventSettingsSynchronizer.handle((QueryDebuggerEventSettingsReply)reply);
        } else if (reply instanceof SetExceptionSettingsReply) {
            this.setExceptionSettingsSynchronizer.handle((SetExceptionSettingsReply)reply);
        } else if (reply instanceof ProcessStartReply) {
            this.processStartSynchronizer.handle((ProcessStartReply)reply);
        } else if (reply instanceof SetDebuggerEventSettingsReply) {
            this.setDebuggerEventSettingsSynchronizer.handle((SetDebuggerEventSettingsReply)reply);
        } else {
            throw new IllegalStateException("IE01105: Unknown reply");
        }
    }

    public void removeListener(IDebugEventListener listener) {
        this.listeners.removeListener(listener);
    }
}

