/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BreakpointSynchronizer {
    private final IDebugger debugger;
    private final BreakpointManager manager;
    private final InternalBreakpointManagerListener managerListener = new InternalBreakpointManagerListener();

    public BreakpointSynchronizer(IDebugger debugger) {
        this.debugger = Preconditions.checkNotNull(debugger, "IE00795: Debugger argument can not be null");
        this.manager = Preconditions.checkNotNull(debugger.getBreakpointManager(), "Error: debugger.getBreakpointManager() argument can not be null");
        this.manager.addListener(this.managerListener);
    }

    private void deleteBreakPoints(Set<BreakpointAddress> addresses, BreakpointType type) {
        if (addresses.size() == 0) {
            return;
        }
        try {
            this.debugger.removeBreakpoints(addresses, type);
        }
        catch (DebugExceptionWrapper exception) {
            this.manager.removeBreakpointsPassive(BreakpointType.REGULAR, Sets.newHashSet(addresses));
            String string2 = String.valueOf(type.toString());
            NaviLogger.severe(new StringBuilder(59 + String.valueOf(string2).length()).append("Error: Debugger could not remove ").append(string2).append(" breakpoints. Exception %s").toString(), exception);
        }
    }

    private void echoBreakpointStateChange(Map.Entry<Breakpoint, BreakpointStatus> breakpointToOldStatus, Set<BreakpointAddress> toSet) {
        if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.ECHO) == BreakpointStatus.BREAKPOINT_ENABLED) {
            toSet.add(breakpointToOldStatus.getKey().getAddress());
        }
    }

    private void regularBreakpointStateChange(Map.Entry<Breakpoint, BreakpointStatus> breakpointToOldStatus, Set<BreakpointAddress> toSet, Set<BreakpointAddress> toRemoveFromDebugger, Set<BreakpointAddress> toRemoveFromManager) {
        BreakpointStatus oldStatus = breakpointToOldStatus.getValue();
        if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_ENABLED) {
            toSet.add(breakpointToOldStatus.getKey().getAddress());
        } else if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_DELETING) {
            if (oldStatus == BreakpointStatus.BREAKPOINT_INVALID || oldStatus == BreakpointStatus.BREAKPOINT_DISABLED) {
                toRemoveFromManager.add(breakpointToOldStatus.getKey().getAddress());
            } else {
                toRemoveFromDebugger.add(breakpointToOldStatus.getKey().getAddress());
            }
        } else if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_DISABLED && oldStatus != BreakpointStatus.BREAKPOINT_DELETING && oldStatus != BreakpointStatus.BREAKPOINT_INVALID && oldStatus != BreakpointStatus.BREAKPOINT_INACTIVE) {
            toRemoveFromDebugger.add(breakpointToOldStatus.getKey().getAddress());
        }
    }

    private void setBreakPoints(Set<BreakpointAddress> addresses, BreakpointType type) {
        if (addresses.size() != 0) {
            try {
                this.debugger.setBreakPoints(addresses, type);
            }
            catch (DebugExceptionWrapper exception) {
                this.manager.setBreakpointStatus(Sets.newHashSet(addresses), type, BreakpointStatus.BREAKPOINT_DISABLED);
                String string2 = String.valueOf(type.toString());
                NaviLogger.severe(new StringBuilder(56 + String.valueOf(string2).length()).append("Error: Debugger could not set ").append(string2).append(" breakpoints. Exception %s").toString(), exception);
            }
        }
    }

    private void stepBreakpointStateChange(Map.Entry<Breakpoint, BreakpointStatus> breakpointToOldStatus, Set<BreakpointAddress> toSet, Set<BreakpointAddress> toRemove) {
        if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.STEP) == BreakpointStatus.BREAKPOINT_ENABLED) {
            toSet.add(breakpointToOldStatus.getKey().getAddress());
        } else if (this.manager.getBreakpointStatus(breakpointToOldStatus.getKey().getAddress(), BreakpointType.STEP) == BreakpointStatus.BREAKPOINT_DELETING) {
            toRemove.add(breakpointToOldStatus.getKey().getAddress());
        }
    }

    private class InternalBreakpointManagerListener
    implements BreakpointManagerListener {
        private InternalBreakpointManagerListener() {
        }

        private List<BreakpointAddress> echoBreakPointsAddedHandler(List<Breakpoint> breakPoints) {
            ArrayList<BreakpointAddress> addresses = new ArrayList<BreakpointAddress>();
            HashSet<BreakpointAddress> addressesForManager = new HashSet<BreakpointAddress>();
            for (Breakpoint breakpoint : breakPoints) {
                Preconditions.checkArgument(BreakpointSynchronizer.this.manager.getBreakpointStatus(breakpoint.getAddress(), BreakpointType.ECHO) == BreakpointStatus.BREAKPOINT_ENABLED, "Internal Error: Breakpoint with type echo has unexpected status");
                if (BreakpointSynchronizer.this.debugger.isConnected()) {
                    if (this.isBreakpointInsideModules(breakpoint, BreakpointSynchronizer.this.debugger.getProcessManager().getModules())) {
                        addresses.add(breakpoint.getAddress());
                        continue;
                    }
                    addressesForManager.add(breakpoint.getAddress());
                    continue;
                }
                NaviLogger.severe("Internal Error: It should only be possible to set echo breakpoints when the debugger is connected", new Object[0]);
            }
            BreakpointSynchronizer.this.manager.setBreakpointStatus(addressesForManager, BreakpointType.ECHO, BreakpointStatus.BREAKPOINT_INACTIVE);
            return addresses;
        }

        private boolean isBreakpointInsideModules(Breakpoint breakpoint, List<MemoryModule> list) {
            RelocatedAddress bpAddress = BreakpointSynchronizer.this.debugger.fileToMemory(breakpoint.getAddress().getModule(), breakpoint.getAddress().getAddress());
            for (MemoryModule module : list) {
                boolean addressOk = bpAddress.getAddress().toBigInteger().compareTo(module.getBaseAddress().getAddress().toBigInteger()) >= 0 && bpAddress.getAddress().toBigInteger().compareTo(module.getBaseAddress().getAddress().toBigInteger().add(BigInteger.valueOf(module.getSize()))) <= 0;
                if (!addressOk || module.getName().compareToIgnoreCase(breakpoint.getAddress().getModule().getConfiguration().getName()) != 0) continue;
                return true;
            }
            return false;
        }

        private List<BreakpointAddress> regularBreakPointsAddedHandler(List<Breakpoint> breakPoints) {
            ArrayList<BreakpointAddress> addresses = new ArrayList<BreakpointAddress>();
            HashSet<BreakpointAddress> addressesForManager = new HashSet<BreakpointAddress>();
            for (Breakpoint breakpoint : breakPoints) {
                if (!BreakpointSynchronizer.this.debugger.isConnected()) continue;
                if (this.isBreakpointInsideModules(breakpoint, BreakpointSynchronizer.this.debugger.getProcessManager().getModules())) {
                    addresses.add(breakpoint.getAddress());
                    continue;
                }
                addressesForManager.add(breakpoint.getAddress());
            }
            BreakpointSynchronizer.this.manager.setBreakpointStatus(addressesForManager, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_INACTIVE);
            return addresses;
        }

        private void removeBreakpoints(Set<BreakpointAddress> addresses, BreakpointType type) {
            if (addresses.size() != 0) {
                try {
                    BreakpointSynchronizer.this.debugger.removeBreakpoints(addresses, type);
                }
                catch (DebugExceptionWrapper exception) {
                    String string2 = String.valueOf(type.toString());
                    NaviLogger.severe(new StringBuilder(59 + String.valueOf(string2).length()).append("Error: Debugger could not remove ").append(string2).append(" breakpoints. Exception %s").toString(), exception);
                }
            }
        }

        private List<BreakpointAddress> stepBreakPointsAddedHandler(List<Breakpoint> breakpoints) {
            ArrayList<BreakpointAddress> addresses = new ArrayList<BreakpointAddress>();
            HashSet<BreakpointAddress> addressesForManager = new HashSet<BreakpointAddress>();
            for (Breakpoint breakpoint : breakpoints) {
                Preconditions.checkArgument(BreakpointSynchronizer.this.manager.getBreakpointStatus(breakpoint.getAddress(), BreakpointType.STEP) == BreakpointStatus.BREAKPOINT_INACTIVE, "Internal Error: Breakpoint with type STEP has unexpected status");
                Preconditions.checkArgument(BreakpointSynchronizer.this.debugger.isConnected(), "Internal Error: It should only be possible to set step breakpoints when the debugger is connected");
                if (this.isBreakpointInsideModules(breakpoint, BreakpointSynchronizer.this.debugger.getProcessManager().getModules())) {
                    addresses.add(breakpoint.getAddress());
                    continue;
                }
                addressesForManager.add(breakpoint.getAddress());
            }
            BreakpointSynchronizer.this.manager.setBreakpointStatus(addressesForManager, BreakpointType.STEP, BreakpointStatus.BREAKPOINT_INACTIVE);
            return addresses;
        }

        @Override
        public void breakpointsAdded(List<Breakpoint> breakpoints) {
            BreakpointType breakpointType = breakpoints.get(0).getType();
            for (Breakpoint currentBreakPoint : breakpoints) {
                Preconditions.checkArgument(currentBreakPoint.getType() == breakpointType, "Error: breakpoint types are not equal for all breakpoints");
            }
            HashSet<BreakpointAddress> addresses = new HashSet<BreakpointAddress>();
            switch (breakpointType) {
                case ECHO: {
                    addresses.addAll(this.echoBreakPointsAddedHandler(breakpoints));
                    break;
                }
                case REGULAR: {
                    addresses.addAll(this.regularBreakPointsAddedHandler(breakpoints));
                    break;
                }
                case STEP: {
                    addresses.addAll(this.stepBreakPointsAddedHandler(breakpoints));
                }
            }
            if (addresses.size() > 0) {
                BreakpointSynchronizer.this.setBreakPoints(addresses, breakpointType);
                BreakpointSynchronizer.this.manager.setBreakpointStatus(addresses, breakpointType, BreakpointStatus.BREAKPOINT_ACTIVE);
            }
        }

        private void enableSingleBPCondition(Breakpoint breakpoint) {
            BreakpointStatus status = BreakpointSynchronizer.this.manager.getBreakpointStatus(breakpoint.getAddress(), BreakpointType.REGULAR);
            if ((status.equals((Object)BreakpointStatus.BREAKPOINT_ENABLED) || status.equals((Object)BreakpointStatus.BREAKPOINT_ACTIVE)) && breakpoint.getCondition() != null) {
                try {
                    BreakpointSynchronizer.this.debugger.setBreakPointCondition(breakpoint.getAddress(), breakpoint.getCondition());
                }
                catch (DebugExceptionWrapper exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void breakpointsConditionChanged(Set<Breakpoint> breakpoints) {
            for (Breakpoint breakpoint : breakpoints) {
                this.enableSingleBPCondition(breakpoint);
            }
        }

        @Override
        public void breakpointsDescriptionChanged(Set<Breakpoint> breakpoints) {
        }

        @Override
        public void breakpointsRemoved(Set<Breakpoint> breakpoints) {
            if (breakpoints.size() != 0) {
                HashSet<BreakpointAddress> echoAddresses = Sets.newHashSet();
                HashSet<BreakpointAddress> stepAddresses = Sets.newHashSet();
                HashSet<BreakpointAddress> regularAddresses = Sets.newHashSet();
                for (Breakpoint breakpoint : breakpoints) {
                    switch (breakpoint.getType()) {
                        case ECHO: {
                            echoAddresses.add(breakpoint.getAddress());
                            break;
                        }
                        case STEP: {
                            stepAddresses.add(breakpoint.getAddress());
                            break;
                        }
                        case REGULAR: {
                            regularAddresses.add(breakpoint.getAddress());
                        }
                    }
                }
                this.removeBreakpoints(echoAddresses, BreakpointType.ECHO);
                this.removeBreakpoints(stepAddresses, BreakpointType.STEP);
                this.removeBreakpoints(regularAddresses, BreakpointType.REGULAR);
            }
        }

        @Override
        public void breakpointsStatusChanged(Map<Breakpoint, BreakpointStatus> breakpointsToOldStatus, BreakpointStatus newStatus) {
            HashSet<BreakpointAddress> regularBreakpointAddressesToAdd = new HashSet<BreakpointAddress>();
            HashSet<BreakpointAddress> regularBreakpointAddressesToRemoveFromDebugger = new HashSet<BreakpointAddress>();
            HashSet<BreakpointAddress> regularBreakpointAddressesToRemoveFromManager = new HashSet<BreakpointAddress>();
            HashSet<BreakpointAddress> stepBreakpointAddressesToAdd = new HashSet<BreakpointAddress>();
            HashSet<BreakpointAddress> stepBreakpointAddressesToRemove = new HashSet<BreakpointAddress>();
            HashSet<BreakpointAddress> echoBreakPointAddressesToAdd = new HashSet<BreakpointAddress>();
            for (Map.Entry<Breakpoint, BreakpointStatus> breakpointToOldStatus : breakpointsToOldStatus.entrySet()) {
                BreakpointType type = breakpointToOldStatus.getKey().getType();
                switch (type) {
                    case REGULAR: {
                        BreakpointSynchronizer.this.regularBreakpointStateChange(breakpointToOldStatus, regularBreakpointAddressesToAdd, regularBreakpointAddressesToRemoveFromDebugger, regularBreakpointAddressesToRemoveFromManager);
                        break;
                    }
                    case ECHO: {
                        BreakpointSynchronizer.this.echoBreakpointStateChange(breakpointToOldStatus, echoBreakPointAddressesToAdd);
                        break;
                    }
                    case STEP: {
                        BreakpointSynchronizer.this.stepBreakpointStateChange(breakpointToOldStatus, stepBreakpointAddressesToAdd, stepBreakpointAddressesToRemove);
                        break;
                    }
                }
            }
            if (BreakpointSynchronizer.this.debugger.isConnected()) {
                if (!echoBreakPointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.setBreakPoints(echoBreakPointAddressesToAdd, BreakpointType.ECHO);
                }
                if (!stepBreakpointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.setBreakPoints(stepBreakpointAddressesToAdd, BreakpointType.STEP);
                }
                if (!regularBreakpointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.setBreakPoints(regularBreakpointAddressesToAdd, BreakpointType.REGULAR);
                    this.breakpointAddressesConditionChanged(regularBreakpointAddressesToAdd);
                }
                if (!regularBreakpointAddressesToRemoveFromDebugger.isEmpty()) {
                    BreakpointSynchronizer.this.deleteBreakPoints(regularBreakpointAddressesToRemoveFromDebugger, BreakpointType.REGULAR);
                }
                if (!regularBreakpointAddressesToRemoveFromManager.isEmpty()) {
                    BreakpointSynchronizer.this.manager.removeBreakpointsPassive(BreakpointType.REGULAR, regularBreakpointAddressesToRemoveFromManager);
                }
            } else {
                if (!echoBreakPointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.manager.setBreakpointStatus(echoBreakPointAddressesToAdd, BreakpointType.ECHO, BreakpointStatus.BREAKPOINT_INACTIVE);
                }
                if (!regularBreakpointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.manager.setBreakpointStatus(regularBreakpointAddressesToAdd, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_INACTIVE);
                }
                if (!stepBreakpointAddressesToAdd.isEmpty()) {
                    BreakpointSynchronizer.this.manager.setBreakpointStatus(stepBreakpointAddressesToAdd, BreakpointType.STEP, BreakpointStatus.BREAKPOINT_DELETING);
                }
                if (!stepBreakpointAddressesToRemove.isEmpty()) {
                    BreakpointSynchronizer.this.manager.removeBreakpointsPassive(BreakpointType.STEP, stepBreakpointAddressesToRemove);
                }
                if (!regularBreakpointAddressesToRemoveFromDebugger.isEmpty()) {
                    BreakpointSynchronizer.this.manager.removeBreakpointsPassive(BreakpointType.REGULAR, regularBreakpointAddressesToRemoveFromDebugger);
                }
                if (!regularBreakpointAddressesToRemoveFromManager.isEmpty()) {
                    BreakpointSynchronizer.this.manager.removeBreakpointsPassive(BreakpointType.REGULAR, regularBreakpointAddressesToRemoveFromManager);
                }
            }
        }

        private void breakpointAddressesConditionChanged(Set<BreakpointAddress> regularBreakpointAddressesToAdd) {
            for (BreakpointAddress address : regularBreakpointAddressesToAdd) {
                this.enableSingleBPCondition(BreakpointSynchronizer.this.manager.getBreakpoint(BreakpointType.REGULAR, address));
            }
        }
    }
}

