/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.HashSet;

public final class BreakpointSetSynchronizer
extends ReplySynchronizer<BreakpointSetReply> {
    public BreakpointSetSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(BreakpointSetReply reply) {
        BreakpointManager manager = this.getDebugger().getBreakpointManager();
        HashSet<BreakpointAddress> addressesToActivate = new HashSet<BreakpointAddress>();
        HashSet<BreakpointAddress> addressesToInvalidate = new HashSet<BreakpointAddress>();
        for (Pair<RelocatedAddress, Integer> resultPair : reply.getAddresses()) {
            if (resultPair.second() == 0) {
                BreakpointAddress breakpointAddress = DebuggerHelpers.getBreakpointAddress(this.getDebugger(), resultPair.first());
                if (manager.getBreakpointStatus(breakpointAddress, BreakpointType.REGULAR) == BreakpointStatus.BREAKPOINT_DISABLED) continue;
                addressesToActivate.add(breakpointAddress);
                continue;
            }
            addressesToInvalidate.add(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), resultPair.first()));
        }
        manager.setBreakpointStatus(addressesToInvalidate, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_INVALID);
        manager.setBreakpointStatus(addressesToActivate, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ACTIVE);
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, BreakpointSetReply reply) {
        listener.receivedReply(reply);
    }
}

