/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger.synchronizers;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ReplySynchronizer;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class BreakpointHitSynchronizer
extends ReplySynchronizer<BreakpointHitReply> {
    public BreakpointHitSynchronizer(IDebugger debugger, ListenerProvider<IDebugEventListener> listeners) {
        super(debugger, listeners);
    }

    @Override
    protected void handleSuccess(BreakpointHitReply reply) {
        ProcessManager processManager = this.getDebugger().getProcessManager();
        RelocatedAddress eventAddress = null;
        RegisterValues registerValues = reply.getRegisterValues();
        long tid = reply.getThreadId();
        for (ThreadRegisters threadRegisters : registerValues) {
            if (tid != threadRegisters.getTid()) continue;
            for (RegisterValue registerValue : threadRegisters) {
                if (!registerValue.isPc()) continue;
                eventAddress = new RelocatedAddress(new CAddress(registerValue.getValue()));
            }
        }
        if (eventAddress == null) {
            throw new IllegalStateException("IE00173: register reply did not include program counter");
        }
        this.updateHitBreakpoints(DebuggerHelpers.getBreakpointAddress(this.getDebugger(), eventAddress));
        try {
            TargetProcessThread thread2 = processManager.getThread(reply.getThreadId());
            for (ThreadRegisters threadRegisters : registerValues) {
                if (tid != threadRegisters.getTid()) continue;
                thread2.setRegisterValues(threadRegisters.getRegisters());
                break;
            }
            processManager.setActiveThread(thread2);
            thread2.setCurrentAddress(eventAddress);
        }
        catch (MaybeNullException exception) {
            NaviLogger.info("Error: there is no thread with the specified thread id %d Exception: %s", reply.getThreadId(), exception);
        }
    }

    @Override
    protected void notifyListener(IDebugEventListener listener, BreakpointHitReply reply) {
        listener.receivedReply(reply);
    }
}

