/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.DebugConnection;
import com.google.security.zynamics.binnavi.debug.debugger.AbstractDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateListener;

public final class TcpDebugger
extends AbstractDebugger {
    private DebugConnection debuggerConnection;
    private final DebuggerTemplate template;
    private final IDebuggerTemplateListener internalTemplateListener = new InternalTemplateListener();
    private final DebugTargetSettings debugTargetSettings;

    public TcpDebugger(DebuggerTemplate template, DebugTargetSettings targetSettings) {
        this.template = Preconditions.checkNotNull(template, "IE00818: Debugger template argument can not be null");
        this.debuggerConnection = new DebugConnection(this.template.getHost(), this.template.getPort());
        this.debugTargetSettings = Preconditions.checkNotNull(targetSettings, "IE01670: targetSettings argument can not be null");
        this.template.addListener(this.internalTemplateListener);
    }

    private void updateConnection() {
        if (this.debuggerConnection == null || !this.isConnected()) {
            this.debuggerConnection = new DebugConnection(this.template.getHost(), this.template.getPort());
        }
    }

    @Override
    public void close() {
        super.setTerminated();
        this.debuggerConnection = null;
    }

    @Override
    public void connect() throws DebugExceptionWrapper {
        super.connect(this.debuggerConnection);
    }

    @Override
    public DebugTargetSettings getDebugTargetSettings() {
        return this.debugTargetSettings;
    }

    @Override
    public int getId() {
        return this.template.getId();
    }

    @Override
    public String getPrintableString() {
        return String.format("%s (%s:%d)", this.template.getName(), this.template.getHost(), this.template.getPort());
    }

    public String toString() {
        return this.getPrintableString();
    }

    private class InternalTemplateListener
    implements IDebuggerTemplateListener {
        private InternalTemplateListener() {
        }

        @Override
        public void changedHost(DebuggerTemplate debugger) {
            TcpDebugger.this.updateConnection();
        }

        @Override
        public void changedName(DebuggerTemplate debugger) {
        }

        @Override
        public void changedPort(DebuggerTemplate debugger) {
            TcpDebugger.this.updateConnection();
        }
    }
}

