/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.util.ArrayList;
import java.util.List;

public final class ProjectTargetSettings
implements DebugTargetSettings {
    private final INaviProject project;

    public ProjectTargetSettings(INaviProject project) {
        this.project = project;
    }

    @Override
    public List<INaviView> getViewsWithAddresses(List<UnrelocatedAddress> addresses, boolean all) {
        try {
            return this.project.getViewsWithAddresses(addresses, all);
        }
        catch (CouldntLoadDataException e2) {
            NaviLogger.severe("Error: Could not load data. Exception: %s", e2);
            return new ArrayList<INaviView>();
        }
    }

    @Override
    public String readSetting(String key) throws CouldntLoadDataException {
        return this.project.readSetting(key);
    }

    @Override
    public void writeSetting(String key, String value) throws CouldntSaveDataException {
        this.project.writeSetting(key, value);
    }
}

