/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.math.BigInteger;

public final class MemoryRangeCalculator {
    private MemoryRangeCalculator() {
    }

    public static Pair<IAddress, Integer> calculateRequestRange(BigInteger offset, int size, IAddress sectionStart, IAddress sectionEnd) {
        BigInteger availableBefore = offset.subtract(sectionStart.toBigInteger());
        BigInteger availableAfter = sectionEnd.toBigInteger().subtract(offset).add(BigInteger.ONE);
        BigInteger loadBefore = availableBefore.compareTo(BigInteger.valueOf(3L * (long)size)) == -1 ? availableBefore : BigInteger.valueOf(3L * (long)size);
        BigInteger loadAfter = availableAfter.compareTo(BigInteger.valueOf(3L * (long)size)) == -1 ? availableAfter : BigInteger.valueOf(3L * (long)size);
        BigInteger realOffset = offset.subtract(loadBefore);
        int realSize = (int)loadBefore.add(loadAfter).longValue();
        return new Pair<IAddress, Integer>(new CAddress(realOffset), realSize);
    }

    public static Pair<IAddress, Integer> calculateRequestRange(IDebugger debugger, BigInteger offset, int size) {
        MemoryMap mmap = debugger.getProcessManager().getMemoryMap();
        MemorySection section = mmap.findOffset(offset);
        if (section == null) {
            return new Pair<IAddress, Integer>(new CAddress(offset), size);
        }
        return MemoryRangeCalculator.calculateRequestRange(offset, size, section.getStart(), section.getEnd());
    }
}

