/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IAddressConverter;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public final class DefaultAddressConverter
implements IAddressConverter {
    private final IAddress sectionMemoryStartAddress;
    private final IAddress fileMemoryStartAddress;

    public DefaultAddressConverter(IAddress membase, IAddress filebase) {
        this.sectionMemoryStartAddress = Preconditions.checkNotNull(membase, "IE00817: Memory base argument can not be null");
        this.fileMemoryStartAddress = Preconditions.checkNotNull(filebase, "IE00819: File base argument can not be null");
    }

    @Override
    public RelocatedAddress fileToMemory(UnrelocatedAddress address) {
        Preconditions.checkNotNull(address, "IE00820: Address argument can not be null");
        return new RelocatedAddress(new CAddress(address.getAddress().toLong() - this.fileMemoryStartAddress.toLong() + this.sectionMemoryStartAddress.toLong()));
    }

    @Override
    public UnrelocatedAddress memoryToFile(RelocatedAddress address) {
        Preconditions.checkNotNull(address, "IE00821: Address argument can not be null");
        return new UnrelocatedAddress(new CAddress(address.getAddress().toLong() - this.sectionMemoryStartAddress.toLong() + this.fileMemoryStartAddress.toLong()));
    }
}

