/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.net.NetHelpers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DebuggerTemplateManager
implements Iterable<DebuggerTemplate>,
IDatabaseObject {
    private final List<DebuggerTemplate> debuggers = new ArrayList<DebuggerTemplate>();
    private final SQLProvider sqlProvider;
    private final ListenerProvider<IDebuggerTemplateManagerListener> listeners = new ListenerProvider();

    public DebuggerTemplateManager(SQLProvider provider) {
        this.sqlProvider = Preconditions.checkNotNull(provider, "IE00805: Provider argument can not be null");
    }

    public void addDebugger(DebuggerTemplate debugger) {
        Preconditions.checkNotNull(debugger, "IE00806: Debugger can not be null");
        Preconditions.checkArgument(!this.debuggers.contains(debugger), "IE00807: Can not add debugger description more than once");
        Preconditions.checkArgument(debugger.inSameDatabase(this.sqlProvider), "IE00808: Debugger template and debugger template manager are in different databases");
        this.debuggers.add(debugger);
        for (IDebuggerTemplateManagerListener listener : this.listeners) {
            try {
                listener.addedDebugger(this, debugger);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void addListener(IDebuggerTemplateManagerListener listener) {
        this.listeners.addListener(listener);
    }

    public DebuggerTemplate createDebugger(String name, String host, int port) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00809: Name argument can not be null");
        Preconditions.checkNotNull(host, "IE00810: Host argument can not be null");
        Preconditions.checkArgument(NetHelpers.isValidPort(port), "IE00811: Invalid port");
        DebuggerTemplate debugger = this.sqlProvider.createDebuggerTemplate(name, host, port);
        this.addDebugger(debugger);
        return debugger;
    }

    public int debuggerCount() {
        return this.debuggers.size();
    }

    public DebuggerTemplate findDebugger(int debuggerId) {
        for (DebuggerTemplate description : this.debuggers) {
            if (description.getId() != debuggerId) continue;
            return description;
        }
        return null;
    }

    public DebuggerTemplate getDebugger(int index) {
        return this.debuggers.get(index);
    }

    public List<DebuggerTemplate> getDebuggers() {
        return new ArrayList<DebuggerTemplate>(this.debuggers);
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.sqlProvider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.sqlProvider == provider;
    }

    @Override
    public Iterator<DebuggerTemplate> iterator() {
        return this.debuggers.iterator();
    }

    public void removeDebugger(DebuggerTemplate debugger) throws CouldntDeleteException {
        Preconditions.checkNotNull(debugger, "IE00812: Debugger argument can not be null");
        Preconditions.checkArgument(debugger.inSameDatabase(this.sqlProvider), "IE00813: Debugger template and debugger template manager are not in the same database");
        this.sqlProvider.deleteDebugger(debugger);
        this.debuggers.remove(debugger);
        for (IDebuggerTemplateManagerListener listener : this.listeners) {
            try {
                listener.removedDebugger(this, debugger);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void removeListener(IDebuggerTemplateManagerListener listener) {
        this.listeners.removeListener(listener);
    }
}

