/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

public final class DebuggerErrorCodes {
    public static final int SUCCESS = 0;
    public static final int COULDNT_START_SERVER = 1;
    public static final int COULDNT_CONNECT_TO_BINNAVI = 2;
    public static final int CONNECTION_CLOSED = 3;
    public static final int CONNECTION_ERROR = 4;
    public static final int PAGE_NOT_WRITABLE = 5;
    public static final int COULDNT_WRITE_MEMORY = 6;
    public static final int COULDNT_ENTER_DEBUG_MODE = 7;
    public static final int COULDNT_OPEN_TARGET_PROCESS = 8;
    public static final int COULDNT_DEBUG_TARGET_PROCESS = 9;
    public static final int PAGE_NOT_READABLE = 14;
    private static final String[] ERROR_MESSAGES = new String[]{"Success", "Could not start the debug server.", "The debugger could not connect to BinNavi.", "The connection to the debugger closed.", "Connection error.", "An accessed page is not writable.", "Could not write to the memory of the target process.", "The debugger could not enter the debug mode.", "The debugger could not open the target process.", "The debugger could not debug the target process.", "An accessed page is not readable."};

    private DebuggerErrorCodes() {
    }

    public static String codeToMessage(int code2) {
        if (code2 >= 0 && code2 < ERROR_MESSAGES.length) {
            return ERROR_MESSAGES[code2];
        }
        return String.format("Unknown error (Code %d)", code2);
    }
}

