/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.DebugConnection;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.DefaultAddressConverter;
import com.google.security.zynamics.binnavi.debug.debugger.MemorySynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IAddressConverter;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IMemoryProvider;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.BreakpointSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.DebuggerSynchronizer;
import com.google.security.zynamics.binnavi.debug.debugger.synchronizers.ThreadStateSynchronizer;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDebugger
implements IDebugger {
    private DebugConnection connection;
    private final DebuggerSynchronizer synchronizer;
    private final ProcessManager processManager = new ProcessManager();
    private final BreakpointManager breakpointManager = new BreakpointManager();
    private final BookmarkManager bookmarkManager = new BookmarkManager();
    private final Map<INaviModule, IAddressConverter> addressConverters = new HashMap<INaviModule, IAddressConverter>();
    private final Map<INaviModule, IAddress> baseAddresses = new HashMap<INaviModule, IAddress>();
    private final MemorySynchronizer memorySynchronizer;
    private final BreakpointSynchronizer breakpointSynchronizer = new BreakpointSynchronizer(this);
    private final ThreadStateSynchronizer threadStateSynchronizer = new ThreadStateSynchronizer(this);

    protected AbstractDebugger() {
        this.synchronizer = new DebuggerSynchronizer(this);
        this.memorySynchronizer = new MemorySynchronizer(this);
    }

    private void ensureConnection() throws DebugExceptionWrapper {
        if (!this.isConnected()) {
            throw new DebugExceptionWrapper("Error: Debugger is not connected");
        }
    }

    private Set<RelocatedAddress> relocate(Set<BreakpointAddress> addresses) {
        HashSet<RelocatedAddress> relocatedAddresses = new HashSet<RelocatedAddress>();
        for (BreakpointAddress breakpointAddress : addresses) {
            relocatedAddresses.add(this.fileToMemory(breakpointAddress.getModule(), breakpointAddress.getAddress()));
        }
        return relocatedAddresses;
    }

    protected final void connect(DebugConnection connection) throws DebugExceptionWrapper {
        if (this.isConnected()) {
            throw new IllegalStateException("IE01270: Debugger is already connected");
        }
        this.connection = connection;
        try {
            this.connection.addEventListener(this.synchronizer);
            this.connection.startConnection();
        }
        catch (ConnectException e2) {
            this.connection.removeEventListener(this.synchronizer);
            this.connection = null;
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public final void addListener(IDebugEventListener listener) {
        this.synchronizer.addListener(listener);
    }

    @Override
    public void cancelTargetSelection() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendCancelTargetSelection();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public boolean canDebug(INaviModule module) {
        return this.addressConverters.keySet().contains(module);
    }

    @Override
    public void detach() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendDetachMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public RelocatedAddress fileToMemory(INaviModule module, UnrelocatedAddress address) {
        if (module == null) {
            return new RelocatedAddress(address.getAddress());
        }
        IAddressConverter converter = this.addressConverters.get(module);
        if (converter == null) {
            throw new IllegalStateException(String.format("Error: No address converter configured for module '%s'", module.getConfiguration().getName()));
        }
        return converter.fileToMemory(address);
    }

    @Override
    public final BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public final BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Override
    public void getMemoryMap() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendMemoryMapMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public final IMemoryProvider getMemoryProvider() {
        return this.memorySynchronizer.getMemoryProvider();
    }

    @Override
    public INaviModule getModule(RelocatedAddress address) {
        ArrayList<Map.Entry<INaviModule, IAddress>> baseList = new ArrayList<Map.Entry<INaviModule, IAddress>>(this.baseAddresses.entrySet());
        Collections.sort(baseList, new Comparator<Map.Entry<INaviModule, IAddress>>(){

            @Override
            public int compare(Map.Entry<INaviModule, IAddress> lhs, Map.Entry<INaviModule, IAddress> rhs) {
                return lhs.getValue().toBigInteger().compareTo(rhs.getValue().toBigInteger());
            }
        });
        for (int i2 = 0; i2 < baseList.size(); ++i2) {
            Map.Entry current = (Map.Entry)baseList.get(i2);
            if (i2 == baseList.size() - 1) {
                return (INaviModule)current.getKey();
            }
            Map.Entry next = (Map.Entry)baseList.get(i2 + 1);
            if (address.getAddress().toBigInteger().compareTo(((IAddress)current.getValue()).toBigInteger()) < 0 || address.getAddress().toBigInteger().compareTo(((IAddress)next.getValue()).toBigInteger()) != -1) continue;
            return (INaviModule)current.getKey();
        }
        return null;
    }

    @Override
    public List<INaviModule> getModules() {
        return new ArrayList<INaviModule>(this.baseAddresses.keySet());
    }

    @Override
    public final ProcessManager getProcessManager() {
        return this.processManager;
    }

    @Override
    public void halt() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendHaltMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public final boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public final UnrelocatedAddress memoryToFile(RelocatedAddress address) {
        Preconditions.checkNotNull(address, "IE00790: Address argument can not be null");
        ArrayList<Map.Entry<INaviModule, IAddress>> baseList = new ArrayList<Map.Entry<INaviModule, IAddress>>(this.baseAddresses.entrySet());
        Collections.sort(baseList, new Comparator<Map.Entry<INaviModule, IAddress>>(){

            @Override
            public int compare(Map.Entry<INaviModule, IAddress> lhs, Map.Entry<INaviModule, IAddress> rhs) {
                return lhs.getValue().toBigInteger().compareTo(rhs.getValue().toBigInteger());
            }
        });
        for (int i2 = 0; i2 < baseList.size(); ++i2) {
            Map.Entry current = (Map.Entry)baseList.get(i2);
            if (i2 == baseList.size() - 1) {
                return this.memoryToFile((INaviModule)current.getKey(), address);
            }
            Map.Entry next = (Map.Entry)baseList.get(i2 + 1);
            if (address.getAddress().toBigInteger().compareTo(((IAddress)current.getValue()).toBigInteger()) < 0 || address.getAddress().toBigInteger().compareTo(((IAddress)next.getValue()).toBigInteger()) != -1) continue;
            return this.memoryToFile((INaviModule)current.getKey(), address);
        }
        throw new IllegalStateException("IE00791: No module in the debugger");
    }

    @Override
    public final UnrelocatedAddress memoryToFile(INaviModule module, RelocatedAddress address) {
        Preconditions.checkNotNull(module, "IE00792: Module argument can not be null");
        Preconditions.checkNotNull(address, "IE00793: Address argument can not be null");
        IAddressConverter converter = this.addressConverters.get(module);
        Preconditions.checkNotNull(converter, "IE00162: Module addresses can not be converted because the debugger has no relocation information for the module");
        return converter.memoryToFile(address);
    }

    @Override
    public int readMemory(IAddress offset, int size) throws DebugExceptionWrapper {
        Preconditions.checkNotNull(offset, "IE00794: Address argument can not be null");
        this.ensureConnection();
        try {
            return this.connection.sendReadMemoryMessage(offset, size);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void readRegisters() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendRegisterRequestMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void removeBreakpoints(Set<BreakpointAddress> addresses, BreakpointType type) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendRemoveBreakpointsMessage(this.relocate(addresses), type);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public final void removeListener(IDebugEventListener listener) {
        this.synchronizer.removeListener(listener);
    }

    @Override
    public int requestFileSystem() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            return this.connection.sendRequestFileSystem();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void requestFileSystem(String path) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendRequestFileSystem(path);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void requestMemoryRange(IAddress address) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendMemoryRangeMessage(address);
        }
        catch (IOException exception) {
            throw new DebugExceptionWrapper(exception);
        }
    }

    @Override
    public int requestProcessList() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            return this.connection.sendRequestProcessList();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void resume() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendResumeMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void resumeThread(long tid) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendResumeThreadMessage(tid);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public int search(IAddress start, int size, byte[] data) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            return this.connection.sendSearchMessage(start, size, data);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void selectFile(String name) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendSelectFileMessage(name);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void selectProcess(int pid) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendSelectProcessMessage(pid);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public final void setAddressTranslator(INaviModule module, IAddress fileBase, IAddress imageBase) {
        this.baseAddresses.put(module, imageBase);
        this.addressConverters.put(module, new DefaultAddressConverter(imageBase, fileBase));
    }

    @Override
    public void setBreakPointCondition(BreakpointAddress address, Condition condition) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendSetBreakpointConditionMessage(this.fileToMemory(address.getModule(), address.getAddress()), condition);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void setBreakPoints(Set<BreakpointAddress> addresses, BreakpointType type) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendBreakpointsMessage(this.relocate(addresses), type);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void setDebuggerEventSettings(DebuggerEventSettings eventSettings) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendDebuggerEventSettingsMessage(eventSettings);
        }
        catch (IOException exception) {
            throw new DebugExceptionWrapper(exception);
        }
    }

    @Override
    public void setExceptionSettings(Collection<DebuggerException> exceptions2) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendExceptionSettingsMessage(exceptions2);
        }
        catch (IOException exception) {
            throw new DebugExceptionWrapper(exception);
        }
    }

    @Override
    public int setRegister(long tid, int index, BigInteger value) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            return this.connection.sendSetRegisterMessage(tid, index, value);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void setTerminated() {
        if (this.connection != null) {
            this.connection.removeEventListener(this.synchronizer);
        }
        if (this.connection != null) {
            this.connection.shutdown();
            this.connection = null;
        }
    }

    @Override
    public void singleStep() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendSingleStepMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void suspendThread(long tid) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendSuspendThreadMessage(tid);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public void terminate() throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            this.connection.sendTerminateMessage();
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }

    @Override
    public int writeMemory(IAddress address, byte[] data) throws DebugExceptionWrapper {
        this.ensureConnection();
        try {
            return this.connection.sendWriteMemoryMessage(address, data);
        }
        catch (IOException e2) {
            throw new DebugExceptionWrapper(e2);
        }
    }
}

