/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ExceptionOccurredReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers.AbstractReplyParser;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExceptionOccurredParser
extends AbstractReplyParser<ExceptionOccurredReply> {
    public ExceptionOccurredParser(ClientReader clientReader) {
        super(clientReader, 64);
    }

    @Override
    protected ExceptionOccurredReply parseError(int packetId) {
        throw new IllegalStateException("IE01086: Received invalid reply from the debug client");
    }

    @Override
    public ExceptionOccurredReply parseSuccess(int packetId, int argumentCount) throws IOException {
        Preconditions.checkArgument(argumentCount == 1, "IE00068: Unexpected number of argument while parsing exception occured packet");
        byte[] data = this.parseData();
        Preconditions.checkNotNull(data, "IE00095: Data argument can not be null");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            Node node = document.getFirstChild();
            long threadId = Long.valueOf(node.getAttributes().getNamedItem("threadId").getNodeValue());
            RelocatedAddress address = new RelocatedAddress(new CAddress(new BigInteger(node.getAttributes().getNamedItem("address").getNodeValue())));
            long exceptionCode = Long.valueOf(node.getAttributes().getNamedItem("exceptionCode").getNodeValue());
            String exceptionName = node.getAttributes().getNamedItem("exceptionName").getNodeValue();
            if (exceptionName.isEmpty()) {
                exceptionName = "Unknown exception";
            }
            return new ExceptionOccurredReply(packetId, 0, threadId, exceptionCode, address, exceptionName);
        }
        catch (Exception exception) {
            CUtilityFunctions.logException(exception);
            throw new IllegalStateException("IE00097: Unexpected error while parsing exception occured packet");
        }
    }
}

