/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers;

import com.google.security.zynamics.binnavi.debug.connection.helpers.DebugProtocolHelper;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.io.IOException;

public abstract class AbstractReplyParser<T extends DebuggerReply> {
    public static final int PARSER_ERROR = 9999;
    private final ClientReader workerInputStream;
    private final int successType;

    protected AbstractReplyParser(ClientReader workerInputStream, int type) {
        this.workerInputStream = workerInputStream;
        this.successType = type;
    }

    private int parseSimpleInteger() throws IOException {
        return (int)DebugProtocolHelper.readDWord(this.workerInputStream);
    }

    protected IAddress parseAddress() throws IOException {
        return new CAddress(DebugProtocolHelper.readAddress(this.workerInputStream));
    }

    protected byte[] parseData() throws IOException {
        return DebugProtocolHelper.readData(this.workerInputStream);
    }

    protected abstract T parseError(int var1) throws IOException;

    protected int parseInteger() throws IOException {
        return (int)DebugProtocolHelper.readThreadId(this.workerInputStream);
    }

    protected abstract T parseSuccess(int var1, int var2) throws IOException;

    protected long parseThreadId() throws IOException {
        return DebugProtocolHelper.readThreadId(this.workerInputStream);
    }

    public T parse(int type, int messageId) throws IOException {
        int argumentCount = this.parseSimpleInteger();
        if (type == this.successType) {
            return this.parseSuccess(messageId, argumentCount);
        }
        return this.parseError(messageId);
    }
}

