/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.replies;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.zylib.disassembly.IAddress;

public final class ReadMemoryReply
extends DebuggerReply {
    private final IAddress startAddress;
    private final byte[] memoryData;

    public ReadMemoryReply(int packetId, int errorCode, IAddress address, byte[] data) {
        super(packetId, errorCode);
        if (this.success()) {
            Preconditions.checkNotNull(address, "IE01066: Address argument can not be null");
            Preconditions.checkNotNull(data, "IE01067: Data argument can not be null");
        } else {
            if (address != null) {
                throw new IllegalArgumentException("IE01068: Address argument must be null");
            }
            if (data != null) {
                throw new IllegalArgumentException("IE01069: Data argument must be null");
            }
        }
        this.startAddress = address;
        this.memoryData = data == null ? null : (byte[])data.clone();
    }

    public IAddress getAddress() {
        return this.startAddress;
    }

    public byte[] getData() {
        return this.memoryData == null ? null : (byte[])this.memoryData.clone();
    }
}

