/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.replies;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;

public abstract class AnyBreakpointHitReply
extends DebuggerReply {
    private final long threadId;
    private final RegisterValues registerValues;

    protected AnyBreakpointHitReply(int packetId, int errorCode, long tid, RegisterValues registerValues) {
        super(packetId, errorCode);
        if (this.success()) {
            Preconditions.checkNotNull(registerValues, "IE01054: Register values argument can not be null");
            boolean foundThread = false;
            for (ThreadRegisters threadRegisters : registerValues) {
                if (threadRegisters.getTid() != tid) continue;
                foundThread = true;
            }
            if (!foundThread) {
                throw new IllegalArgumentException("IE01301: Invalid thread ID");
            }
        } else if (registerValues != null) {
            throw new IllegalArgumentException("IE01055: Register values argument must be null");
        }
        this.threadId = tid;
        this.registerValues = registerValues;
    }

    public RegisterValues getRegisterValues() {
        return this.registerValues;
    }

    public long getThreadId() {
        return this.threadId;
    }
}

