/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.parsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MemoryStringParser;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MessageParserException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class RegisterValuesParser {
    private RegisterValuesParser() {
    }

    private static String getAttribute(Node node, String attribute) throws MessageParserException {
        Node attributeNode = node.getAttributes().getNamedItem(attribute);
        if (attributeNode == null) {
            throw new MessageParserException(String.format("IE01041: Thread node of register values message does not have a '%s' attribute", attribute));
        }
        return attributeNode.getNodeValue();
    }

    private static boolean hasAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name) != null;
    }

    private static ThreadRegisters parseThreadNode(Node node) throws MessageParserException {
        ArrayList<RegisterValue> registerValues = new ArrayList<RegisterValue>();
        long tid = Long.valueOf(node.getAttributes().getNamedItem("id").getNodeValue());
        NodeList children = node.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            String registerName = RegisterValuesParser.getAttribute(child, "name");
            BigInteger registerValue = new BigInteger(RegisterValuesParser.getAttribute(child, "value"), 16);
            byte[] memory = MemoryStringParser.parseMemoryString(RegisterValuesParser.getAttribute(child, "memory"));
            boolean isPc = RegisterValuesParser.hasAttribute(child, "pc");
            boolean isSp = RegisterValuesParser.hasAttribute(child, "sp");
            registerValues.add(new RegisterValue(registerName, registerValue, memory, isPc, isSp));
        }
        return new ThreadRegisters(tid, registerValues);
    }

    public static RegisterValues parse(byte[] data) throws MessageParserException {
        Preconditions.checkNotNull(data, "IE01299: Data argument can not be null");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            NodeList nodes = document.getFirstChild().getChildNodes();
            ArrayList<ThreadRegisters> threads = new ArrayList<ThreadRegisters>();
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node node = nodes.item(i2);
                if (!node.getNodeName().equals("Thread")) {
                    throw new MessageParserException(String.format("IE01040: Invalid node '%s' found during register values message parsing", node.getNodeName()));
                }
                threads.add(RegisterValuesParser.parseThreadNode(node));
            }
            return new RegisterValues(threads);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            CUtilityFunctions.logException(exception);
            throw new MessageParserException(exception.getLocalizedMessage());
        }
    }
}

