/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.parsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MemoryModuleParser;
import com.google.security.zynamics.binnavi.debug.connection.packets.parsers.MessageParserException;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessStart;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProcessStartParser {
    private ProcessStartParser() {
    }

    private static ThreadState convertThreadState(int value) {
        switch (value) {
            case 0: {
                return ThreadState.RUNNING;
            }
            case 1: {
                return ThreadState.SUSPENDED;
            }
        }
        throw new IllegalArgumentException(String.format("Received invalid thread state %d", value));
    }

    private static String getAttribute(Node node, String attribute) throws MessageParserException {
        Node attributeNode = node.getAttributes().getNamedItem(attribute);
        if (attributeNode == null) {
            throw new MessageParserException(String.format("%s message does not have a '%s' attribute", node.getNodeName(), attribute));
        }
        return attributeNode.getNodeValue();
    }

    private static TargetProcessThread parseThreadInformation(Node node) throws MessageParserException {
        long id = Long.valueOf(ProcessStartParser.getAttribute(node, "threadId"));
        ThreadState state = ProcessStartParser.convertThreadState(Integer.valueOf(ProcessStartParser.getAttribute(node, "threadState")));
        return new TargetProcessThread(id, state);
    }

    public static ProcessStart parse(byte[] data) throws MessageParserException {
        Preconditions.checkNotNull(data, "IE00066: Data argument can not be null");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        TargetProcessThread thread2 = null;
        MemoryModule module = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data, 0, data.length));
            NodeList nodes = document.getFirstChild().getChildNodes();
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node node = nodes.item(i2);
                String nodeName = node.getNodeName();
                if ("thread".equals(nodeName)) {
                    thread2 = ProcessStartParser.parseThreadInformation(node);
                    continue;
                }
                if ("module".equals(nodeName)) {
                    module = MemoryModuleParser.parseModule(node);
                    continue;
                }
                throw new MessageParserException(String.format("Found unknown node '%s' in process start string", nodeName));
            }
        }
        catch (Exception exception) {
            CUtilityFunctions.logException(exception);
            throw new MessageParserException(exception.getLocalizedMessage());
        }
        Preconditions.checkNotNull(thread2, "IE01665: E00068: Received invalid process start string (missing thread information)");
        Preconditions.checkNotNull(module, "IE01668: E00069: Received invalid target process start string (missing module information)");
        return new ProcessStart(thread2, module);
    }
}

