/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.commands.conditions;

import com.google.security.zynamics.binnavi.debug.connection.packets.commands.conditions.NodeIdCollector;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.ConditionNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.ConditionNodeSwitcher;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.ExpressionNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.FormulaNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.IdentifierNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.MemoryNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.NumberNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.RelationNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.conditions.SubNode;
import com.google.security.zynamics.zylib.general.ByteHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ConditionTreeFlattener {
    private static final int ID_EXPRESSION_NODE = 0;
    private static final int ID_FORMULA_NODE = 1;
    private static final int ID_IDENTIFIER_NODE = 2;
    private static final int ID_MEMORY_NODE = 3;
    private static final int ID_NUMBER_NODE = 4;
    private static final int ID_RELATION_NODE = 5;
    private static final int ID_SUB_NODE = 6;

    private ConditionTreeFlattener() {
    }

    private static void addAll(List<Byte> list, byte[] data) {
        for (byte b2 : data) {
            list.add(b2);
        }
    }

    private static List<Byte> flatten(ConditionNode root, Map<ConditionNode, Integer> nodeIds) {
        ArrayList<Byte> flattenedTree = new ArrayList<Byte>();
        ConditionTreeFlattener.addAll(flattenedTree, ConditionTreeFlattener.getType(root));
        List<Byte> payload = ConditionTreeFlattener.getPayload(root);
        ConditionTreeFlattener.addAll(flattenedTree, ByteHelpers.toBigEndianDword(payload.size()));
        flattenedTree.addAll(payload);
        ConditionTreeFlattener.addAll(flattenedTree, ByteHelpers.toBigEndianDword(root.getChildren().size()));
        for (ConditionNode child : root.getChildren()) {
            ConditionTreeFlattener.addAll(flattenedTree, ByteHelpers.toBigEndianDword(nodeIds.get(child).intValue()));
        }
        for (ConditionNode child : root.getChildren()) {
            flattenedTree.addAll(ConditionTreeFlattener.flatten(child, nodeIds));
        }
        return flattenedTree;
    }

    private static List<Byte> getPayload(ConditionNode root) {
        final ArrayList<Byte> data = new ArrayList<Byte>();
        ConditionNodeSwitcher.process(root, new ConditionNodeSwitcher.NodeSwitcher<Void>(){

            @Override
            public Void process(ExpressionNode node) {
                ConditionTreeFlattener.addAll(data, node.getOperator().getBytes());
                return null;
            }

            @Override
            public Void process(FormulaNode node) {
                ConditionTreeFlattener.addAll(data, node.getOperator().getBytes());
                return null;
            }

            @Override
            public Void process(IdentifierNode node) {
                ConditionTreeFlattener.addAll(data, node.getName().getBytes());
                return null;
            }

            @Override
            public Void process(MemoryNode node) {
                return null;
            }

            @Override
            public Void process(NumberNode node) {
                ConditionTreeFlattener.addAll(data, ByteHelpers.toBigEndianDword(node.getValue()));
                return null;
            }

            @Override
            public Void process(RelationNode node) {
                ConditionTreeFlattener.addAll(data, node.getOperator().getBytes());
                return null;
            }

            @Override
            public Void process(SubNode node) {
                return null;
            }
        });
        return data;
    }

    private static byte[] getType(ConditionNode node) {
        return ByteHelpers.toBigEndianDword(ConditionNodeSwitcher.process(node, new ConditionNodeSwitcher.NodeSwitcher<Integer>(){

            @Override
            public Integer process(ExpressionNode node) {
                return 0;
            }

            @Override
            public Integer process(FormulaNode node) {
                return 1;
            }

            @Override
            public Integer process(IdentifierNode node) {
                return 2;
            }

            @Override
            public Integer process(MemoryNode node) {
                return 3;
            }

            @Override
            public Integer process(NumberNode node) {
                return 4;
            }

            @Override
            public Integer process(RelationNode node) {
                return 5;
            }

            @Override
            public Integer process(SubNode node) {
                return 6;
            }
        }).intValue());
    }

    public static byte[] flatten(ConditionNode root) {
        return ByteHelpers.toArray(ConditionTreeFlattener.flatten(root, NodeIdCollector.getNodeIds(root)));
    }
}

