/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.commands;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageAddressArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugMessageRawArgument;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DebugCommand;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.conditions.ConditionTreeFlattener;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;

public final class SetBreakpointConditionCommand
extends DebugCommand {
    public SetBreakpointConditionCommand(int packetId, RelocatedAddress address, Condition condition) {
        super(94, packetId);
        Preconditions.checkNotNull(address, "IE01027: Address argument can not be null");
        Preconditions.checkNotNull(condition, "IE01028: Condition argument can not be null");
        this.addArgument(new DebugMessageAddressArgument(address.getAddress()));
        try {
            this.addArgument(new DebugMessageRawArgument(ConditionTreeFlattener.flatten(condition.getRoot())));
        }
        catch (MaybeNullException e2) {
            this.addArgument(new DebugMessageRawArgument(new byte[0]));
        }
    }
}

