/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection.packets.arguments;

import com.google.security.zynamics.binnavi.debug.connection.packets.arguments.DebugArgumentType;
import com.google.security.zynamics.zylib.strings.Commafier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DebugMessageArgument {
    private final List<Byte> byteData = new ArrayList<Byte>();

    protected DebugMessageArgument(DebugArgumentType type) {
        this.appendInt(type.getValue());
    }

    private static void prependInteger(List<Byte> list, int number) {
        list.add(0, (byte)(number & 0xFF));
        list.add(0, (byte)(number >> 8 & 0xFF));
        list.add(0, (byte)(number >> 16 & 0xFF));
        list.add(0, (byte)(number >> 24 & 0xFF));
    }

    protected final void appendBytes(byte[] data) {
        for (byte element : data) {
            this.byteData.add(element);
        }
    }

    protected final void appendInt(int number) {
        for (int i2 = 3; i2 >= 0; --i2) {
            this.byteData.add((byte)(number >> 8 * i2 & 0xFF));
        }
    }

    protected final void appendLong(BigInteger number) {
        for (int i2 = 7; i2 >= 0; --i2) {
            this.byteData.add((byte)number.shiftRight(8 * i2).and(BigInteger.valueOf(255L)).longValue());
        }
    }

    public final List<Byte> getBytes() {
        ArrayList<Byte> list = new ArrayList<Byte>(this.byteData);
        DebugMessageArgument.prependInteger(list, list.size() - 4);
        return list;
    }

    public String toString() {
        return Commafier.commafy(this.getBytes(), " | ");
    }
}

