/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.DebugCommandType;
import com.google.security.zynamics.binnavi.debug.connection.helpers.DebugProtocolHelper;
import com.google.security.zynamics.binnavi.debug.connection.interfaces.ClientReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AuthenticationFailedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerClosedUnexpectedlyReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DetachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TerminateReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers.AbstractReplyParser;
import com.google.security.zynamics.binnavi.debug.connection.packets.replyparsers.ParserFactory;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public final class ReceiveWorker
implements Runnable {
    private boolean peacefulShutdown = false;
    private final ClientReader workerInputStream;
    private boolean shutDown = false;
    private final LinkedBlockingQueue<DebuggerReply> eventQueue;
    private final ParserFactory parserFactory;
    private boolean waitingForAuthentication = true;

    public ReceiveWorker(ClientReader inputStream, LinkedBlockingQueue<DebuggerReply> eventQueue) {
        this.workerInputStream = Preconditions.checkNotNull(inputStream, "IE00743: Input stream can not be null");
        this.eventQueue = Preconditions.checkNotNull(eventQueue, "IE00744: Event queue can't be null");
        this.parserFactory = new ParserFactory(inputStream);
    }

    private boolean isPeacefulShutdownEvent(DebuggerReply message2) {
        return message2.success() && (message2 instanceof DetachReply || message2 instanceof TerminateReply || message2 instanceof ProcessClosedReply);
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                int messageId;
                int messageType;
                block13: {
                    messageType = 0;
                    messageId = 0;
                    try {
                        messageType = (int)DebugProtocolHelper.readDWord(this.workerInputStream);
                        if (this.waitingForAuthentication) {
                            this.waitingForAuthentication = false;
                            if (messageType == 1312904777) continue;
                            this.eventQueue.put(new AuthenticationFailedReply());
                            break;
                        }
                        messageId = (int)DebugProtocolHelper.readDWord(this.workerInputStream);
                        if (messageType == 17) break block13;
                        NaviLogger.info(String.format("Debug message of type %d %s arrived", messageType, DebugCommandType.getMessageName(messageType)), new Object[0]);
                    }
                    catch (IOException ex) {
                        if (!this.peacefulShutdown) {
                            this.eventQueue.put(new DebuggerClosedUnexpectedlyReply());
                        }
                        break;
                    }
                }
                AbstractReplyParser<?> parser2 = this.parserFactory.getParser(messageType);
                Object message2 = parser2.parse(messageType, messageId);
                this.eventQueue.add((DebuggerReply)message2);
                if (!this.isPeacefulShutdownEvent((DebuggerReply)message2)) continue;
                this.peacefulShutdown = true;
            }
        }
        catch (IOException e2) {
            NaviLogger.severe("Shutting down receive worker because of an IO exception", new Object[0]);
            try {
                this.eventQueue.put(new DebuggerClosedUnexpectedlyReply());
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException e3) {
            NaviLogger.severe("Shutting down receive worker because of an interrupted exception", new Object[0]);
            try {
                this.eventQueue.put(new DebuggerClosedUnexpectedlyReply());
            }
            catch (InterruptedException e1) {
                CUtilityFunctions.logException(e1);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        this.waitingForAuthentication = true;
        this.shutDown = true;
        this.peacefulShutdown = true;
    }
}

