/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.connection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.AbstractConnection;
import com.google.security.zynamics.binnavi.debug.connection.SocketReader;
import com.google.security.zynamics.binnavi.debug.connection.packets.commands.DebugCommand;
import com.google.security.zynamics.zylib.net.NetHelpers;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;

public final class DebugConnection
extends AbstractConnection {
    private Socket debugClientSocket = null;
    private final String debugClientHost;
    private final int debugClientPort;

    public DebugConnection(String host, int port) {
        this.debugClientHost = Preconditions.checkNotNull(host, "IE00739: Host can not be null");
        Preconditions.checkArgument(NetHelpers.isValidPort(port), "IE00740: Invalid port");
        this.debugClientPort = port;
    }

    @Override
    protected int sendPacket(DebugCommand message2) throws IOException {
        this.debugClientSocket.getOutputStream().write(message2.toByteArray());
        this.debugClientSocket.getOutputStream().flush();
        return message2.getPacketId();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            if (this.debugClientSocket != null) {
                this.debugClientSocket.close();
            }
        }
        catch (IOException e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    @Override
    public void startConnection() throws ConnectException {
        NaviLogger.info("Trying to connect to the debug client via TCP/IP", new Object[0]);
        try {
            this.debugClientSocket = new Socket(this.debugClientHost, this.debugClientPort);
            super.startConnection(new SocketReader(this.debugClientSocket));
        }
        catch (Exception e2) {
            throw new ConnectException(e2.getMessage());
        }
    }
}

