/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.config;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.config.PluginConfigItem;
import com.google.security.zynamics.common.config.AbstractConfigItem;
import com.google.security.zynamics.common.config.TypedPropertiesWrapper;
import java.util.List;

public class GeneralSettingsConfigItem
extends AbstractConfigItem {
    static final String PROPERTY_PREFIX = "GeneralSettings.";
    private static final String IDA_DIRECTORY = "GeneralSettings.IdaDirectory";
    private static final String IDA_DIRECTORY_DEFAULT = "";
    private String idaDirectory = "";
    private static final String DEFAULT_EXPORTER = "GeneralSettings.DefaultExporter";
    private static final int DEFAULT_EXPORTER_DEFAULT = 0;
    private int defaultExporter = 0;
    private static final String SUPPORT_EMAIL_ADDRESS = "GeneralSettings.SupportEmailAddress";
    private static final String SUPPORT_EMAIL_ADDRESS_DEFAULT = "";
    private String supportEmailAddress = "";
    private static final String SHOW_EXPIRING_INFORMATION = "GeneralSettings.ShowExpiringInformation";
    private static final boolean SHOW_EXPIRING_INFORMATION_DEFAULT = true;
    private Boolean showExpiringInformation = true;
    private static final String SHOW_EXPIRED_INFORMATION = "GeneralSettings.ShowExpiredInformation";
    private static final boolean SHOW_EXPIRED_INFORMATION_DEFAULT = true;
    private Boolean showExpiredInformation = true;
    private static final String MAXIMIZE_WINDOW = "GeneralSettings.MaximizeWindow";
    private static final boolean MAXIMIZE_WINDOW_DEFAULT = true;
    private Boolean maximizeWindow = true;
    private static final String LOG_LEVEL = "GeneralSettings.LogLevel";
    private static final int LOG_LEVEL_DEFAULT = 0;
    private int logLevel = 0;
    private static final String DEFAULT_SCRIPTING_LANGUAGE = "GeneralSettings.DefaultScriptingLanguage";
    private static final String DEFAULT_SCRIPTING_LANGUAGE_DEFAULT = "";
    private String defaultScriptingLanguage = "";
    private static final String PLUGINS_PREFIX = "GeneralSettings.Plugins.";
    private static final String PLUGINS_COUNT = "GeneralSettings.Plugins.Count";
    private static final int PLUGINS_COUNT_DEFAULT = 0;
    private static final String LAST_DIRECTORY = "GeneralSettings.LastDirectory";
    private static final String LAST_DIRECTORY_DEFAULT = "";
    private static String lastDirectory = "";
    private List<String> idbDirectories = Lists.newArrayList();
    private LastOpenWindowConfigItem lastOpenWindow = new LastOpenWindowConfigItem();
    private GraphWindowConfigItem graphWindow = new GraphWindowConfigItem();
    private List<PluginConfigItem> plugins = Lists.newArrayList();

    @Override
    public void load(TypedPropertiesWrapper properties) {
        this.idaDirectory = properties.getString(IDA_DIRECTORY, "");
        this.defaultExporter = properties.getInteger(DEFAULT_EXPORTER, 0);
        this.supportEmailAddress = properties.getString(SUPPORT_EMAIL_ADDRESS, "");
        this.showExpiringInformation = properties.getBoolean(SHOW_EXPIRING_INFORMATION, true);
        this.showExpiredInformation = properties.getBoolean(SHOW_EXPIRED_INFORMATION, true);
        this.maximizeWindow = properties.getBoolean(MAXIMIZE_WINDOW, true);
        this.logLevel = properties.getInteger(LOG_LEVEL, 0);
        this.defaultScriptingLanguage = properties.getString(DEFAULT_SCRIPTING_LANGUAGE, "");
        this.lastOpenWindow.load(properties);
        this.graphWindow.load(properties);
        lastDirectory = properties.getString(LAST_DIRECTORY, "");
        int i2 = 0;
        while (i2 < properties.getInteger(PLUGINS_COUNT, 0)) {
            PluginConfigItem plugin = new PluginConfigItem();
            String string2 = String.valueOf(PLUGINS_PREFIX);
            int n2 = i2++;
            plugin.loadWithKeyPrefix(properties, new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(".").toString());
            this.plugins.add(plugin);
        }
    }

    @Override
    public void store(TypedPropertiesWrapper properties) {
        properties.setString(IDA_DIRECTORY, this.idaDirectory);
        properties.setInteger(DEFAULT_EXPORTER, this.defaultExporter);
        properties.setString(SUPPORT_EMAIL_ADDRESS, this.supportEmailAddress);
        properties.setBoolean(SHOW_EXPIRING_INFORMATION, this.showExpiringInformation);
        properties.setBoolean(SHOW_EXPIRED_INFORMATION, this.showExpiredInformation);
        properties.setBoolean(MAXIMIZE_WINDOW, this.maximizeWindow);
        properties.setInteger(LOG_LEVEL, this.logLevel);
        if (this.defaultScriptingLanguage != null) {
            properties.setString(DEFAULT_SCRIPTING_LANGUAGE, this.defaultScriptingLanguage);
        }
        this.lastOpenWindow.store(properties);
        this.graphWindow.store(properties);
        properties.setString(LAST_DIRECTORY, lastDirectory);
        properties.setInteger(PLUGINS_COUNT, this.plugins.size());
        for (int i2 = 0; i2 < this.plugins.size(); ++i2) {
            String string2 = String.valueOf(PLUGINS_PREFIX);
            int n2 = i2;
            this.plugins.get(i2).storeWithKeyPrefix(properties, new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(".").toString());
        }
    }

    public String getIdaDirectory() {
        return this.idaDirectory;
    }

    public void setIdaDirectory(String value) {
        this.idaDirectory = value;
    }

    public List<String> getIdbDirectories() {
        return this.idbDirectories;
    }

    public Integer getDefaultExporter() {
        return this.defaultExporter;
    }

    public void setDefaultExporter(Integer value) {
        this.defaultExporter = value;
    }

    public String getSupportEmailAddress() {
        return this.supportEmailAddress;
    }

    public void setSupportEmailAddress(String value) {
        this.supportEmailAddress = value;
    }

    public Boolean isShowExpiringInformation() {
        return this.showExpiringInformation;
    }

    public void setShowExpiringInformation(Boolean value) {
        this.showExpiringInformation = value;
    }

    public Boolean isShowExpiredInformation() {
        return this.showExpiredInformation;
    }

    public void setShowExpiredInformation(Boolean value) {
        this.showExpiredInformation = value;
    }

    public Boolean isMaximizeWindow() {
        return this.maximizeWindow;
    }

    public void setMaximizeWindow(Boolean value) {
        this.maximizeWindow = value;
    }

    public Integer getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Integer value) {
        this.logLevel = value;
    }

    public String getDefaultScriptingLanguage() {
        return this.defaultScriptingLanguage;
    }

    public void setDefaultScriptingLanguage(String value) {
        this.defaultScriptingLanguage = value;
    }

    public LastOpenWindowConfigItem getLastOpenWindow() {
        return this.lastOpenWindow;
    }

    public GraphWindowConfigItem getGraphWindow() {
        return this.graphWindow;
    }

    public List<PluginConfigItem> getPlugins() {
        return this.plugins;
    }

    public void setLastDirectory(String directory) {
        lastDirectory = directory;
    }

    public String getLastDirectory() {
        return lastDirectory;
    }

    public static class GraphWindowConfigItem {
        private static final String SIZE_LEFT_PANEL = "GraphWindow.SizeLeftPanel";
        private static final int SIZE_LEFT_PANEL_DEFAULT = -1;
        private int sizeLeftPanel;
        private static final String SIZE_RIGHT_PANEL = "GraphWindow.SizeRightPanel";
        private static final int SIZE_RIGHT_PANEL_DEFAULT = -1;
        private int sizeRightPanel = -1;
        private static final String SIZE_BOTTOM_PANEL = "GraphWindow.SizeBottomPanel";
        private static final int SIZE_BOTTOM_PANEL_DEFAULT = -1;
        private int sizeBottomPanel = -1;

        public void load(TypedPropertiesWrapper properties) {
            this.sizeLeftPanel = properties.getInteger(SIZE_LEFT_PANEL, -1);
            this.sizeRightPanel = properties.getInteger(SIZE_RIGHT_PANEL, -1);
            this.sizeBottomPanel = properties.getInteger(SIZE_BOTTOM_PANEL, -1);
        }

        public void store(TypedPropertiesWrapper properties) {
            properties.setInteger(SIZE_LEFT_PANEL, this.sizeLeftPanel);
            properties.setInteger(SIZE_RIGHT_PANEL, this.sizeRightPanel);
            properties.setInteger(SIZE_BOTTOM_PANEL, this.sizeBottomPanel);
        }

        public int getSizeLeftPanel() {
            return this.sizeLeftPanel;
        }

        public void setSizeLeftPanel(int value) {
            this.sizeLeftPanel = value;
        }

        public int getSizeRightPanel() {
            return this.sizeRightPanel;
        }

        public void setSizeRightPanel(int value) {
            this.sizeRightPanel = value;
        }

        public int getSizeBottomPanel() {
            return this.sizeBottomPanel;
        }

        public void setSizeBottomPanel(int value) {
            this.sizeBottomPanel = value;
        }
    }

    public class LastOpenWindowConfigItem
    extends AbstractConfigItem {
        private static final String TOP = "LastOpenWindow.Top";
        private static final int TOP_DEFAULT = 0;
        private int top = 0;
        private static final String LEFT = "LastOpenWindow.Left";
        private static final int LEFT_DEFAULT = 0;
        private int left = 0;
        private static final String HEIGHT = "LastOpenWindow.Height";
        private static final int HEIGHT_DEFAULT = 600;
        private int height = 600;
        private static final String WIDTH = "LastOpenWindow.Width";
        private static final int WIDTH_DEFAULT = 800;
        private int width = 800;

        @Override
        public void load(TypedPropertiesWrapper properties) {
            this.top = properties.getInteger(TOP, 0);
            this.left = properties.getInteger(LEFT, 0);
            this.height = properties.getInteger(HEIGHT, 600);
            this.width = properties.getInteger(WIDTH, 800);
        }

        @Override
        public void store(TypedPropertiesWrapper properties) {
            properties.setInteger(TOP, this.top);
            properties.setInteger(LEFT, this.left);
            properties.setInteger(HEIGHT, this.height);
            properties.setInteger(WIDTH, this.width);
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int value) {
            this.top = value;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int value) {
            this.left = value;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int value) {
            this.height = value;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int value) {
            this.width = value;
        }
    }
}

