/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyCodeNodeBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CBreakpointPainter;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CDebuggerPainter;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CDebuggerProviderUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CDebuggerUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CFunctionUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CInstructionUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CModuleUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.COperandUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CSettingsUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.CTagUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CodeNodes.TypeSubstitutionsUpdater;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DefaultAddressConverter;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.CNaviCodeNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CReferenceFinder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class CCodeNodeUpdater
implements IRealizerUpdater<NaviNode> {
    private final ZyGraph graph;
    private final NaviNode node;
    private final INaviCodeNode codeNode;
    private final BackEndDebuggerProvider provider;
    private final CDefaultModifier nodeModifier;
    private IZyNodeRealizer realizer;
    private final CModuleUpdater moduleUpdater;
    private final CInstructionUpdater instructionUpdater;
    private final CFunctionUpdater functionUpdater;
    private final InternalCodeNodeListener codeNodeListener = new InternalCodeNodeListener();
    private final CTagUpdater tagUpdater;
    private final CDebuggerUpdater debuggerUpdater;
    private final CSettingsUpdater settingsUpdater;
    private final COperandUpdater operandTreeUpdater;
    private final TypeSubstitutionsUpdater substitutionsUpdater;
    private final CDebuggerProviderUpdater debuggerProviderListener;

    public CCodeNodeUpdater(ZyGraph graph, NaviNode node, INaviCodeNode codeNode, BackEndDebuggerProvider debuggerProvider) {
        this.graph = Preconditions.checkNotNull(graph, "IE00984: Graph argument can't be null");
        this.node = Preconditions.checkNotNull(node, "IE02238: Node argument can not be null");
        this.codeNode = Preconditions.checkNotNull(codeNode, "IE00985: Code node argument can't be null");
        this.provider = Preconditions.checkNotNull(debuggerProvider, "IE02239: Debugger provider argument can not be null");
        this.nodeModifier = new CDefaultModifier(graph.getSettings(), debuggerProvider);
        this.tagUpdater = new CTagUpdater(graph);
        this.settingsUpdater = new CSettingsUpdater(graph);
        this.operandTreeUpdater = new COperandUpdater(graph);
        this.moduleUpdater = new CModuleUpdater(graph);
        this.instructionUpdater = new CInstructionUpdater(graph);
        this.functionUpdater = new CFunctionUpdater(graph);
        this.debuggerUpdater = new CDebuggerUpdater(graph);
        this.debuggerProviderListener = new CDebuggerProviderUpdater(this.debuggerUpdater);
        this.substitutionsUpdater = new TypeSubstitutionsUpdater(codeNode, node);
        this.initializeListeners();
    }

    private void initializeListeners() {
        try {
            this.codeNode.getParentFunction().addListener(this.functionUpdater);
            this.codeNode.getParentFunction().getModule().addListener(this.moduleUpdater);
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
        HashMap<INaviInstruction, INaviFunction> referenceMap = CReferenceFinder.getCodeReferenceMap(this.codeNode);
        for (INaviFunction functionReference : Sets.newHashSet(referenceMap.values())) {
            functionReference.addListener(this.functionUpdater);
        }
        this.codeNode.addListener(this.codeNodeListener);
        for (INaviInstruction instruction : this.codeNode.getInstructions()) {
            instruction.addListener(this.instructionUpdater);
            for (COperandTree tree : instruction.getOperands()) {
                for (INaviOperandTreeNode currentNode : tree.getNodes()) {
                    currentNode.addListener(this.operandTreeUpdater);
                }
            }
        }
        Iterator<CTag> it = this.codeNode.getTagsIterator();
        while (it.hasNext()) {
            it.next().addListener(this.tagUpdater);
        }
        for (IDebugger debugger : this.provider.getDebuggers()) {
            debugger.getProcessManager().addListener(this.debuggerUpdater);
        }
        this.provider.addListener(this.debuggerProviderListener);
        this.graph.getSettings().getDisplaySettings().addListener(this.settingsUpdater);
        try {
            this.codeNode.getParentFunction().getModule().getTypeManager().addListener(this.substitutionsUpdater);
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }

    private void rebuildNode() {
        this.realizer.regenerate();
        this.graph.updateViews();
    }

    private void removeListeners() {
        try {
            this.codeNode.getParentFunction().removeListener(this.functionUpdater);
            this.codeNode.getParentFunction().getModule().removeListener(this.moduleUpdater);
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
        this.codeNode.removeListener(this.codeNodeListener);
        for (INaviInstruction instruction : this.codeNode.getInstructions()) {
            instruction.removeListener(this.instructionUpdater);
        }
        Iterator<CTag> it = this.codeNode.getTagsIterator();
        while (it.hasNext()) {
            it.next().removeListener(this.tagUpdater);
        }
        for (IDebugger debugger : this.provider.getDebuggers()) {
            debugger.getProcessManager().removeListener(this.debuggerUpdater);
        }
        this.provider.removeListener(this.debuggerProviderListener);
        this.graph.getSettings().getDisplaySettings().removeListener(this.settingsUpdater);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    @Override
    public void generateContent(IZyNodeRealizer realizer, ZyLabelContent content) {
        ZyCodeNodeBuilder.buildContent(content, this.codeNode, this.graph.getSettings(), this.nodeModifier);
        for (INaviInstruction instruction : this.codeNode.getInstructions()) {
            int line;
            INaviModule module = instruction.getModule();
            if (this.provider == null || this.provider.getDebugger(module) == null || !this.graph.getSettings().getDisplaySettings().getShowMemoryAddresses(this.provider.getDebugger(module)) || (line = CCodeNodeHelpers.instructionToLine(this.codeNode, instruction)) == -1) continue;
            ZyLineContent lineContent = this.realizer.getNodeContent().getLineContent(line);
            lineContent.setTextColor(0, 8, Color.RED);
        }
        INaviInstruction instruction = (INaviInstruction)this.codeNode.getInstructions().iterator().next();
        if (instruction != null) {
            INaviModule module = instruction.getModule();
            IDebugger debugger = this.provider.getDebugger(module);
            if (debugger == null) {
                return;
            }
            BreakpointManager manager = debugger.getBreakpointManager();
            CBreakpointPainter.paintBreakpoints(manager, this.node, this.codeNode);
            if (debugger.getProcessManager().getActiveThread() != null) {
                RelocatedAddress instructionPointer = debugger.getProcessManager().getActiveThread().getCurrentAddress();
                MemoryModule memoryModule = debugger.getProcessManager().getModule(instructionPointer);
                UnrelocatedAddress unrelocatedIP = new DefaultAddressConverter(memoryModule.getBaseAddress().getAddress(), module.getConfiguration().getFileBase()).memoryToFile(instructionPointer);
                CDebuggerPainter.updateSingleNodeDebuggerHighlighting(this.graph, unrelocatedIP, this.node);
            }
        }
    }

    @Override
    public void setRealizer(IZyNodeRealizer realizer) {
        this.realizer = realizer;
        this.debuggerUpdater.setRealizer(realizer);
        this.functionUpdater.setRealizer(realizer);
        this.instructionUpdater.setRealizer(realizer);
        this.moduleUpdater.setRealizer(realizer);
        this.operandTreeUpdater.setRealizer(realizer);
        this.settingsUpdater.setRealizer(realizer);
        this.tagUpdater.setRealizer(realizer);
    }

    private class InternalCodeNodeListener
    extends CNaviCodeNodeListenerAdapter {
        private InternalCodeNodeListener() {
        }

        @Override
        public void addedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void appendedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void appendedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void appendedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void changedInstructionColor(CCodeNode codeNode, INaviInstruction instruction, int level, Color color) {
            if (color == null) {
                CCodeNodeUpdater.this.node.clearHighlighting(level, CCodeNodeHelpers.instructionToLine(CCodeNodeUpdater.this.codeNode, instruction));
            } else {
                CCodeNodeUpdater.this.node.setHighlighting(level, CCodeNodeHelpers.instructionToLine(CCodeNodeUpdater.this.codeNode, instruction), color);
            }
        }

        @Override
        public void deletedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void deletedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void deletedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void editedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void editedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void editedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void initializedGlobalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void initializedLocalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void initializedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, List<IComment> comment) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void removedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void taggedNode(INaviViewNode node, CTag tag) {
            tag.addListener(CCodeNodeUpdater.this.tagUpdater);
            CCodeNodeUpdater.this.rebuildNode();
        }

        @Override
        public void untaggedNodes(INaviViewNode node, List<CTag> tags) {
            for (CTag tag : tags) {
                tag.removeListener(CCodeNodeUpdater.this.tagUpdater);
            }
            CCodeNodeUpdater.this.rebuildNode();
        }
    }
}

