/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphDisplaySettingsListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Implementations.CLayoutFunctions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;

public final class CGraphSettingsSynchronizer {
    private final ZyGraph m_graph;
    private final InternalSettingsListener m_settingsListener = new InternalSettingsListener();

    public CGraphSettingsSynchronizer(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE02189: Graph argument can not be null");
        this.m_graph = graph;
        this.m_graph.getSettings().getDisplaySettings().addListener(this.m_settingsListener);
    }

    public void dispose() {
        this.m_graph.getSettings().getDisplaySettings().removeListener(this.m_settingsListener);
    }

    private class InternalSettingsListener
    extends ZyGraphDisplaySettingsListenerAdapter {
        private InternalSettingsListener() {
        }

        @Override
        public void changedGradientBackground(boolean value) {
            CLayoutFunctions.updateBackground(CGraphSettingsSynchronizer.this.m_graph);
        }
    }
}

