/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettings;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettingsListener;

public final class ZyGraphProximitySettings
implements IProximitySettings {
    private int m_proximityBrowsingActivisionThreshold;
    private boolean m_proximityBrowsing;
    private boolean m_proximityBrowsingFrozen = false;
    private boolean m_ProximityPreview;
    private int m_proximityBrowsingChildren;
    private int m_proximityBrowsingParents;
    private GraphSettingsConfigItem m_type;
    private final ListenerProvider<IProximitySettingsListener> m_listeners = new ListenerProvider();

    public ZyGraphProximitySettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE02025: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphProximitySettings(ZyGraphProximitySettings settings) {
        this.m_proximityBrowsing = settings.getProximityBrowsing();
        this.m_proximityBrowsingActivisionThreshold = settings.getProximityBrowsingActivationThreshold();
        this.m_proximityBrowsingChildren = settings.getProximityBrowsingChildren();
        this.m_proximityBrowsingFrozen = settings.getProximityBrowsingFrozen();
        this.m_proximityBrowsingParents = settings.getProximityBrowsingParents();
        this.m_ProximityPreview = settings.getProximityBrowsingPreview();
    }

    @Override
    public void addListener(IProximitySettingsListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean getProximityBrowsing() {
        return this.m_type == null ? this.m_proximityBrowsing : this.m_type.isProximityBrowsing();
    }

    public int getProximityBrowsingActivationThreshold() {
        return this.m_type == null ? this.m_proximityBrowsingActivisionThreshold : this.m_type.getProximityBrowsingThreshold();
    }

    @Override
    public int getProximityBrowsingChildren() {
        return this.m_type == null ? this.m_proximityBrowsingChildren : this.m_type.getProximityBrowsingChildren();
    }

    @Override
    public boolean getProximityBrowsingFrozen() {
        return this.m_proximityBrowsingFrozen;
    }

    @Override
    public int getProximityBrowsingParents() {
        return this.m_type == null ? this.m_proximityBrowsingParents : this.m_type.getProximityBrowsingParents();
    }

    public boolean getProximityBrowsingPreview() {
        return this.m_type == null ? this.m_ProximityPreview : this.m_type.isProximityBrowsingPreview();
    }

    @Override
    public void removeListener(IProximitySettingsListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setProximityBrowsing(boolean value) {
        if (value == this.getProximityBrowsing()) {
            return;
        }
        if (this.m_type == null) {
            this.m_proximityBrowsing = value;
        } else {
            this.m_type.setProximityBrowsing(value);
        }
        for (IProximitySettingsListener listener : this.m_listeners) {
            try {
                listener.changedProximityBrowsing(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setProximityBrowsingActivationThreshold(int value) {
        Preconditions.checkArgument(value >= 0, "IE00889: Threshold argument must not be negative");
        if (value == this.getProximityBrowsingActivationThreshold()) {
            return;
        }
        if (this.m_type == null) {
            this.m_proximityBrowsingActivisionThreshold = value;
        } else {
            this.m_type.setProximityBrowsingThreshold(value);
        }
    }

    public void setProximityBrowsingChildren(int value) {
        Preconditions.checkArgument(value >= -1, "IE00890: Distance argument must not be less than -1");
        if (value == this.getProximityBrowsingChildren()) {
            return;
        }
        if (this.m_type == null) {
            this.m_proximityBrowsingChildren = value;
        } else {
            this.m_type.setProximityBrowsingChildren(value);
        }
        for (IProximitySettingsListener listener : this.m_listeners) {
            try {
                listener.changedProximityBrowsingDepth(value, this.getProximityBrowsingParents());
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setProximityBrowsingFrozen(boolean value) {
        if (value == this.getProximityBrowsingFrozen()) {
            return;
        }
        this.m_proximityBrowsingFrozen = value;
        for (IProximitySettingsListener listener : this.m_listeners) {
            try {
                listener.changedProximityBrowsingFrozen(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setProximityBrowsingParents(int value) {
        Preconditions.checkArgument(value >= -1, "IE00891: Distance argument must not be less than -1");
        if (value == this.getProximityBrowsingParents()) {
            return;
        }
        if (this.m_type == null) {
            this.m_proximityBrowsingParents = value;
        } else {
            this.m_type.setProximityBrowsingParents(value);
        }
    }

    public void setProximityBrowsingPreview(boolean value) {
        if (value == this.getProximityBrowsingPreview()) {
            return;
        }
        if (this.m_type == null) {
            this.m_ProximityPreview = value;
        } else {
            this.m_type.setProximityBrowsingPreview(value);
        }
        for (IProximitySettingsListener listener : this.m_listeners) {
            try {
                listener.changedProximityBrowsingPreview(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

