/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IMouseSettings;
import java.text.ParseException;

public final class ZyGraphMouseSettings
implements IMouseSettings {
    private int m_scrollSensitivity;
    private int m_zoomSensitivity;
    private MouseWheelAction m_mouseWheelAction;
    private final GraphSettingsConfigItem m_type;

    public ZyGraphMouseSettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE02024: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphMouseSettings(ZyGraphMouseSettings settings) {
        this.m_type = null;
        this.m_mouseWheelAction = settings.getMouseWheelAction();
        this.m_scrollSensitivity = settings.getScrollSensitivity();
        this.m_zoomSensitivity = settings.getZoomSensitivity();
    }

    private static MouseWheelAction getMousewheelAction(GraphSettingsConfigItem type) {
        try {
            return MouseWheelAction.parseInt(type.getMouseWheelAction());
        }
        catch (ParseException e2) {
            CUtilityFunctions.logException(e2);
            return MouseWheelAction.ZOOM;
        }
    }

    @Override
    public MouseWheelAction getMouseWheelAction() {
        return this.m_type == null ? this.m_mouseWheelAction : ZyGraphMouseSettings.getMousewheelAction(this.m_type);
    }

    @Override
    public int getScrollSensitivity() {
        return this.m_type == null ? this.m_scrollSensitivity : this.m_type.getScrollSensitivity();
    }

    @Override
    public int getZoomSensitivity() {
        return this.m_type == null ? this.m_zoomSensitivity : this.m_type.getZoomSensitivity();
    }

    public void setMousewheelAction(MouseWheelAction value) {
        Preconditions.checkNotNull(value, "IE00886: Mouse wheel action argument can't be null");
        if (value == this.getMouseWheelAction()) {
            return;
        }
        if (this.m_type == null) {
            this.m_mouseWheelAction = value;
        } else {
            this.m_type.setMouseWheelAction(value.ordinal());
        }
    }

    public void setScrollSensitivity(int value) {
        Preconditions.checkArgument(value >= 0, "IE00892: Sensitivity argument must not be negative");
        if (value == this.getScrollSensitivity()) {
            return;
        }
        if (this.m_type == null) {
            this.m_scrollSensitivity = value;
        } else {
            this.m_type.setScrollSensitivity(value);
        }
    }

    public void setZoomSensitivity(int value) {
        Preconditions.checkArgument(value >= 0, "IE00900: Sensitivity argument must not be negative");
        if (value == this.getZoomSensitivity()) {
            return;
        }
        if (this.m_type == null) {
            this.m_zoomSensitivity = value;
        } else {
            this.m_type.setZoomSensitivity(value);
        }
    }
}

