/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicStyle;

public final class ZyGraphHierarchicalSettings {
    private int m_minimumLayerDistance;
    private int m_minimumNodeDistance;
    private int m_minimumEdgeDistance;
    private int m_minimumNodeEdgeDistance;
    private HierarchicOrientation m_orientation;
    private HierarchicStyle m_style = HierarchicStyle.OCTLINEAR_OPTIMAL;
    private final GraphSettingsConfigItem m_type;

    public ZyGraphHierarchicalSettings(GraphSettingsConfigItem type) {
        this.m_type = Preconditions.checkNotNull(type, "IE02018: Type argument can't be null");
    }

    public ZyGraphHierarchicalSettings(ZyGraphHierarchicalSettings settings) {
        this.m_type = null;
        this.m_style = settings.getStyle();
        this.m_minimumEdgeDistance = settings.getMinimumEdgeDistance();
        this.m_minimumLayerDistance = settings.getMinimumLayerDistance();
        this.m_minimumNodeDistance = settings.getMinimumNodeDistance();
        this.m_minimumNodeEdgeDistance = settings.getMinimumNodeEdgeDistance();
        this.m_orientation = settings.getOrientation();
    }

    private static HierarchicStyle getLayout(GraphSettingsConfigItem type) {
        try {
            return HierarchicStyle.parseInt(type.getHierarchicEdgeRoutingStyle());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return HierarchicStyle.OCTLINEAR_OPTIMAL;
        }
    }

    private static HierarchicOrientation getOrientation(GraphSettingsConfigItem type) {
        try {
            return HierarchicOrientation.parseInt(type.getHierarchicOrientation());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return HierarchicOrientation.VERTICAL;
        }
    }

    public int getMinimumEdgeDistance() {
        return this.m_type == null ? this.m_minimumEdgeDistance : this.m_type.getHierarchicMinimumEdgeDistance();
    }

    public int getMinimumLayerDistance() {
        return this.m_type == null ? this.m_minimumLayerDistance : this.m_type.getHierarchicMinimumLayerDistance();
    }

    public int getMinimumNodeDistance() {
        return this.m_type == null ? this.m_minimumNodeDistance : this.m_type.getHierarchicMinimumNodeDistance();
    }

    public int getMinimumNodeEdgeDistance() {
        return this.m_type == null ? this.m_minimumNodeEdgeDistance : this.m_type.getHierarchicMinimumNodeEdgeDistance();
    }

    public HierarchicOrientation getOrientation() {
        return this.m_type == null ? this.m_orientation : ZyGraphHierarchicalSettings.getOrientation(this.m_type);
    }

    public HierarchicStyle getStyle() {
        return this.m_type == null ? this.m_style : ZyGraphHierarchicalSettings.getLayout(this.m_type);
    }

    public void setMinimumEdgeDistance(int value) {
        Preconditions.checkArgument(value >= 0, "IE00882: Distance argument must not be negative");
        if (value == this.getMinimumEdgeDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_minimumEdgeDistance = value;
        } else {
            this.m_type.setHierarchicMinimumEdgeDistance(value);
        }
    }

    public void setMinimumLayerDistance(int value) {
        Preconditions.checkArgument(value >= 0, "IE00883: Distance argument must not be negative");
        if (value == this.getMinimumLayerDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_minimumLayerDistance = value;
        } else {
            this.m_type.setHierarchicMinimumLayerDistance(value);
        }
    }

    public void setMinimumNodeDistance(int value) {
        Preconditions.checkArgument(value >= 0, "IE00884: Distance argument must not be negative");
        if (value == this.getMinimumNodeDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_minimumNodeDistance = value;
        } else {
            this.m_type.setHierarchicMinimumNodeDistance(value);
        }
    }

    public void setMinimumNodeEdgeDistance(Integer minNodeEdgeDistance) {
        Preconditions.checkArgument(minNodeEdgeDistance >= 0, "Error: Distance argument must not be negative");
        if (minNodeEdgeDistance.intValue() == this.getMinimumNodeEdgeDistance()) {
            return;
        }
        if (this.m_type == null) {
            this.m_minimumNodeEdgeDistance = minNodeEdgeDistance;
        } else {
            this.m_type.setHierarchicMinimumNodeEdgeDistance(minNodeEdgeDistance);
        }
    }

    public void setOrientation(HierarchicOrientation value) {
        Preconditions.checkNotNull(value, "IE00879: Orientation argument can't be null");
        if (value == this.getOrientation()) {
            return;
        }
        if (this.m_type == null) {
            this.m_orientation = value;
        } else {
            this.m_type.setHierarchicOrientation(value.ordinal());
        }
    }

    public void setStyle(HierarchicStyle value) {
        Preconditions.checkNotNull(value, "IE00878: Style argument can't be null");
        if (value == this.getStyle()) {
            return;
        }
        if (this.m_type == null) {
            this.m_style = value;
        } else {
            this.m_type.setHierarchicEdgeRoutingStyle(value.ordinal());
        }
    }
}

