/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphEdgeSettingsListener;
import com.google.security.zynamics.binnavi.config.CallGraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.EdgeHidingMode;

public final class ZyGraphEdgeSettings {
    private boolean displayMultipleEdgesAsOne;
    private EdgeHidingMode edgeHidingMode;
    private int edgeHidingThreshold;
    private boolean drawSelectedBends;
    private final GraphSettingsConfigItem type;
    private final ListenerProvider<IZyGraphEdgeSettingsListener> listeners = new ListenerProvider();

    public ZyGraphEdgeSettings(GraphSettingsConfigItem type) {
        this.type = Preconditions.checkNotNull(type, "IE02017: Type argument can't be null");
        if (type instanceof CallGraphSettingsConfigItem) {
            this.setDisplayMultipleEdgesAsOne(type.isMultipleEdgesAsOne());
        }
    }

    public ZyGraphEdgeSettings(ZyGraphEdgeSettings settings) {
        this.displayMultipleEdgesAsOne = settings.getDisplayMultipleEdgesAsOne();
        this.edgeHidingMode = settings.getEdgeHidingMode();
        this.edgeHidingThreshold = settings.getEdgeHidingThreshold();
        this.drawSelectedBends = settings.getDrawSelectedBends();
        this.type = null;
    }

    private static EdgeHidingMode getEdgeHidingMode(GraphSettingsConfigItem type) {
        try {
            return EdgeHidingMode.parseInt(type.getEdgeHidingMode());
        }
        catch (IllegalStateException e2) {
            CUtilityFunctions.logException(e2);
            return EdgeHidingMode.HIDE_ON_THRESHOLD;
        }
    }

    public void addListener(IZyGraphEdgeSettingsListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean getDisplayMultipleEdgesAsOne() {
        return this.type == null ? this.displayMultipleEdgesAsOne : this.type.isMultipleEdgesAsOne();
    }

    public boolean getDrawSelectedBends() {
        return this.type == null ? this.drawSelectedBends : this.type.isDrawBends();
    }

    public EdgeHidingMode getEdgeHidingMode() {
        return this.type == null ? this.edgeHidingMode : ZyGraphEdgeSettings.getEdgeHidingMode(this.type);
    }

    public int getEdgeHidingThreshold() {
        return this.type == null ? this.edgeHidingThreshold : this.type.getEdgeHidingThreshold();
    }

    public void removeListener(IZyGraphEdgeSettingsListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setDisplayMultipleEdgesAsOne(boolean value) {
        if (value == this.getDisplayMultipleEdgesAsOne()) {
            return;
        }
        if (this.type == null) {
            this.displayMultipleEdgesAsOne = value;
        } else {
            this.type.setMultipleEdgesAsOne(value);
        }
        for (IZyGraphEdgeSettingsListener listener : this.listeners) {
            try {
                listener.changedDisplayMultipleEdgesAsOne(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setDrawSelectedBends(boolean value) {
        if (value == this.getDrawSelectedBends()) {
            return;
        }
        if (this.type == null) {
            this.drawSelectedBends = value;
        } else {
            this.type.setDrawBends(true);
        }
        for (IZyGraphEdgeSettingsListener listener : this.listeners) {
            try {
                listener.changedDrawSelectedBends(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setEdgeHidingMode(EdgeHidingMode value) {
        Preconditions.checkNotNull(value, "IE00877: Edge hiding mode can't be null");
        if (value == this.getEdgeHidingMode()) {
            return;
        }
        if (this.type == null) {
            this.edgeHidingMode = value;
        } else {
            this.type.setEdgeHidingMode(value.ordinal());
        }
        for (IZyGraphEdgeSettingsListener listener : this.listeners) {
            try {
                listener.changedEdgeHidingMode(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setEdgeHidingThreshold(int threshold) {
        if (threshold == this.getEdgeHidingThreshold()) {
            return;
        }
        if (this.type == null) {
            this.edgeHidingThreshold = threshold;
        } else {
            this.type.setEdgeHidingThreshold(threshold);
        }
        for (IZyGraphEdgeSettingsListener listener : this.listeners) {
            try {
                listener.changedEdgeHidingThreshold(threshold);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

