/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphDisplaySettingsListener;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IDisplaySettings;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IDisplaySettingsListener;
import java.util.HashSet;
import java.util.Set;

public final class ZyGraphDisplaySettings
implements IDisplaySettings {
    private boolean m_gradientBackground;
    private boolean m_magnifyingGlassMode;
    private boolean m_showFunctionNodeInformation;
    private final Set<IDebugger> m_showMemoryAddresses = new HashSet<IDebugger>();
    private int m_animationSpeed;
    private boolean m_simplifiedVariableAccess = false;
    private final GraphSettingsConfigItem m_type;
    private final ListenerProvider<IZyGraphDisplaySettingsListener> m_listeners = new ListenerProvider();
    private final ListenerProvider<IDisplaySettingsListener> m_glisteners = new ListenerProvider();

    public ZyGraphDisplaySettings(GraphSettingsConfigItem type) {
        Preconditions.checkNotNull(type, "IE02016: Type argument can't be null");
        this.m_type = type;
    }

    public ZyGraphDisplaySettings(ZyGraphDisplaySettings settings) {
        this.m_type = null;
        this.m_animationSpeed = settings.getAnimationSpeed();
        this.m_gradientBackground = settings.getGradientBackground();
        this.m_showFunctionNodeInformation = settings.getFunctionNodeInformation();
        this.m_simplifiedVariableAccess = settings.getSimplifiedVariableAccess();
    }

    @Override
    public void addListener(IDisplaySettingsListener listener) {
        this.m_glisteners.addListener(listener);
    }

    public void addListener(IZyGraphDisplaySettingsListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public int getAnimationSpeed() {
        return this.m_type == null ? this.m_animationSpeed : this.m_type.getAnimationSpeed();
    }

    public boolean getFunctionNodeInformation() {
        return this.m_type == null ? this.m_showFunctionNodeInformation : this.m_type.isFunctionNodeInformation();
    }

    public boolean getGradientBackground() {
        return this.m_type == null ? this.m_gradientBackground : this.m_type.isGradientBackground();
    }

    @Override
    public boolean getMagnifyingGlassMode() {
        return this.m_magnifyingGlassMode;
    }

    public boolean getShowMemoryAddresses(IDebugger debugger) {
        return this.m_showMemoryAddresses.contains(debugger);
    }

    public boolean getSimplifiedVariableAccess() {
        return this.m_type == null ? this.m_simplifiedVariableAccess : this.m_type.isSimplifiedVariableAccess();
    }

    @Override
    public void removeListener(IDisplaySettingsListener listener) {
        this.m_glisteners.removeListener(listener);
    }

    public void removeListener(IZyGraphDisplaySettingsListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setAnimationSpeed(int animationSpeed) {
        if (animationSpeed == this.getAnimationSpeed()) {
            return;
        }
        if (this.m_type == null) {
            this.m_animationSpeed = animationSpeed;
        } else {
            this.m_type.setAnimationSpeed(animationSpeed);
        }
    }

    public void setFunctionNodeInformation(boolean value) {
        if (value == this.getFunctionNodeInformation()) {
            return;
        }
        if (this.m_type == null) {
            this.m_showFunctionNodeInformation = value;
        } else {
            this.m_type.setFunctionNodeInformation(value);
        }
        for (IZyGraphDisplaySettingsListener listener : this.m_listeners) {
            try {
                listener.changedFunctionNodeInformation(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setGradientBackground(boolean value) {
        if (value == this.getGradientBackground()) {
            return;
        }
        if (this.m_type == null) {
            this.m_gradientBackground = value;
        } else {
            this.m_type.setGradientBackground(value);
        }
        for (IZyGraphDisplaySettingsListener listener : this.m_listeners) {
            try {
                listener.changedGradientBackground(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setMagnifyingGlassMode(boolean value) {
        if (this.m_magnifyingGlassMode == value) {
            return;
        }
        this.m_magnifyingGlassMode = value;
        for (IDisplaySettingsListener listener : this.m_glisteners) {
            try {
                listener.changedMagnifyingGlass(value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setShowMemoryAddresses(IDebugger debugger, boolean selected) {
        if (selected) {
            this.m_showMemoryAddresses.add(debugger);
        } else {
            this.m_showMemoryAddresses.remove(debugger);
        }
        for (IZyGraphDisplaySettingsListener listener : this.m_listeners) {
            try {
                listener.changedShowMemoryAddresses(debugger, selected);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setSimplifiedVariableAccess(boolean simplified) {
        if (simplified == this.getSimplifiedVariableAccess()) {
            return;
        }
        if (this.m_type == null) {
            this.m_simplifiedVariableAccess = simplified;
        } else {
            this.m_type.setSimplifiedVariableAccess(simplified);
        }
        for (IZyGraphDisplaySettingsListener listener : this.m_listeners) {
            try {
                listener.changedSimplifiedVariableAccess(simplified);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

