/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Painters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;

public class CrossReferencePainter {
    private CrossReferencePainter() {
    }

    public static void paintCrossReference(NaviNode node, INaviCodeNode codeNode, TypeInstanceReference reference, INaviInstruction instruction) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkNotNull(codeNode, "Error: codeNode argument can not be null");
        Preconditions.checkNotNull(reference, "Error: reference argument can not be null");
        Preconditions.checkNotNull(instruction, "Error: instruction argument can not be null");
        int line = CCodeNodeHelpers.instructionToLine(codeNode, instruction);
        node.clearHighlighting(600, line);
        node.setHighlighting(600, line, ConfigManager.instance().getColorSettings().getMemRefColor());
    }
}

