/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Painters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ICodeNode;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class CDebuggerPainter {
    private CDebuggerPainter() {
    }

    private static void updateDebuggerHighlighting(UnrelocatedAddress address, NaviNode node, INaviFunctionNode functionNode) {
        if (functionNode.getFunction().getAddress().equals(address.getAddress())) {
            node.setHighlighting(1000, 1, ConfigManager.instance().getDebuggerColorSettings().getActiveLine());
        }
    }

    private static void updateDebuggerHighlighting(ZyGraph graph, NaviNode node, INaviCodeNode codeNode, INaviInstruction instruction) {
        node.setHighlighting(1000, CCodeNodeHelpers.instructionToLine(codeNode, instruction), 11, -1, ConfigManager.instance().getDebuggerColorSettings().getActiveLine());
        if (!node.getRawNode().isVisible()) {
            node.getRawNode().setVisible(true);
            if (graph.getSettings().getProximitySettings().getProximityBrowsing()) {
                graph.showNode(node, true);
            }
            graph.doLayout();
        }
    }

    private static void updateDebuggerHighlighting(ZyGraph graph, UnrelocatedAddress address, NaviNode node, INaviCodeNode codeNode) {
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            if (!instruction.getAddress().equals(address.getAddress())) continue;
            CDebuggerPainter.updateDebuggerHighlighting(graph, node, codeNode, instruction);
        }
    }

    public static void clearDebuggerHighlighting(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE02186: Graph argument can not be null");
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                INaviViewNode rawNode = node.getRawNode();
                if (rawNode instanceof ICodeNode) {
                    INaviCodeNode codeNode = (INaviCodeNode)rawNode;
                    for (INaviInstruction instruction : codeNode.getInstructions()) {
                        node.clearHighlighting(1000, CCodeNodeHelpers.instructionToLine(codeNode, instruction));
                    }
                } else if (rawNode instanceof INaviFunctionNode) {
                    node.clearHighlighting(1000, 1);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static void updateDebuggerHighlighting(final ZyGraph graph, final UnrelocatedAddress address, final INaviModule module) {
        Preconditions.checkNotNull(graph, "IE02187: Graph argument can not be null");
        Preconditions.checkNotNull(address, "IE02188: Address argument can not be null");
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                INaviFunctionNode functionNode;
                INaviViewNode rawNode = node.getRawNode();
                if (rawNode instanceof ICodeNode) {
                    INaviCodeNode codeNode = (INaviCodeNode)rawNode;
                    try {
                        if (module.equals(codeNode.getParentFunction().getModule())) {
                            CDebuggerPainter.updateDebuggerHighlighting(graph, address, node, codeNode);
                        }
                    }
                    catch (MaybeNullException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                } else if (rawNode instanceof INaviFunctionNode && module.equals((functionNode = (INaviFunctionNode)rawNode).getFunction().getModule())) {
                    CDebuggerPainter.updateDebuggerHighlighting(address, node, functionNode);
                }
                return IterationMode.CONTINUE;
            }
        });
        ZyZoomHelpers.zoomToAddress(graph, address.getAddress(), module, false);
    }

    public static void updateSingleNodeDebuggerHighlighting(ZyGraph graph, UnrelocatedAddress address, NaviNode node) {
        Preconditions.checkNotNull(graph, "IE01192: Graph argument can not be null");
        Preconditions.checkNotNull(address, "IE01216: Address argument can not be null");
        INaviViewNode rawNode = node.getRawNode();
        if (rawNode instanceof ICodeNode) {
            INaviCodeNode codeNode = (INaviCodeNode)rawNode;
            CDebuggerPainter.updateDebuggerHighlighting(graph, address, node, codeNode);
        } else if (rawNode instanceof INaviFunctionNode) {
            INaviFunctionNode functionNode = (INaviFunctionNode)rawNode;
            CDebuggerPainter.updateDebuggerHighlighting(address, node, functionNode);
        }
    }
}

