/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Painters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;

public final class CBreakpointPainter {
    private CBreakpointPainter() {
    }

    private static void paintBreakpoints(BreakpointManager manager, NaviNode node) {
        if (node.getRawNode() instanceof INaviCodeNode) {
            CBreakpointPainter.paintBreakpoints(manager, node, (INaviCodeNode)node.getRawNode());
        } else if (node.getRawNode() instanceof INaviFunctionNode) {
            CBreakpointPainter.paintBreakpoints(manager, node, (INaviFunctionNode)node.getRawNode());
        }
    }

    public static void paintBreakpoints(BreakpointManager manager, NaviNode node, INaviCodeNode codeNode) {
        Preconditions.checkNotNull(manager, "IE02171: Manager argument can not be null");
        Preconditions.checkNotNull(node, "IE02172: Node argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02173: Code node argument can not be null");
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            BreakpointAddress address = new BreakpointAddress(instruction.getModule(), new UnrelocatedAddress(instruction.getAddress()));
            int line = CCodeNodeHelpers.instructionToLine(codeNode, instruction);
            if (manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
                int addressCharacters = address.getAddress().getAddress().toHexString().length();
                node.setHighlighting(500, line, 0, addressCharacters, BreakpointManager.getBreakpointColor(manager.getBreakpointStatus(address, BreakpointType.REGULAR)));
                continue;
            }
            node.clearHighlighting(500, line);
        }
    }

    public static void paintBreakpoints(BreakpointManager manager, NaviNode node, INaviFunctionNode functionNode) {
        Preconditions.checkNotNull(manager, "IE02374: Manager argument can not be null");
        Preconditions.checkNotNull(node, "IE02375: Node argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE02376: Code node argument can not be null");
        INaviFunction function = functionNode.getFunction();
        INaviModule module = function.getModule();
        boolean FUNCTION_BREAKPOINT_LINE = true;
        BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(function.getAddress()));
        if (manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
            node.setHighlighting(500, 1, BreakpointManager.getBreakpointColor(manager.getBreakpointStatus(address, BreakpointType.REGULAR)));
        } else {
            node.clearHighlighting(500, 1);
        }
    }

    public static void paintBreakpoints(final BreakpointManager manager, ZyGraph graph) {
        Preconditions.checkNotNull(manager, "IE02179: Manager argument can not be null");
        Preconditions.checkNotNull(graph, "IE02180: Graph argument can not be null");
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                CBreakpointPainter.paintBreakpoints(manager, node);
                return IterationMode.CONTINUE;
            }
        });
    }

    public static void paintBreakpoints(final BreakpointManager manager, ZyGraph graph, BreakpointAddress breakpointAddress) {
        Preconditions.checkNotNull(manager, "IE02181: Manager argument can not be null");
        Preconditions.checkNotNull(graph, "IE02182: Graph argument can not be null");
        Preconditions.checkNotNull(breakpointAddress, "IE02183: Breakpoint address node argument can not be null");
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode naviNode) {
                CBreakpointPainter.paintBreakpoints(manager, naviNode);
                return IterationMode.CONTINUE;
            }
        });
    }
}

