/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.REIL.COperandsDeterminer;
import com.google.security.zynamics.binnavi.REIL.CTranslatorFactory;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;

public final class COperandsMenu
extends JMenu {
    public COperandsMenu(INaviCodeNode node, INaviInstruction instruction, List<ICodeNodeExtension> extensions) throws InternalTranslationException, MaybeNullException {
        super("Operands");
        JMenu operandMenu;
        ITranslator<INaviInstruction> translator = CTranslatorFactory.getTranslator(instruction.getArchitecture());
        if (translator == null) {
            throw new MaybeNullException();
        }
        Pair<Set<String>, Set<String>> operands = COperandsDeterminer.getRegisters(instruction);
        Set<String> inSet = operands.first();
        Set<String> outSet = operands.second();
        JMenu inRegisters = new JMenu("Incoming Registers");
        JMenu outRegisters = new JMenu("Outgoing Registers");
        if (!inSet.isEmpty()) {
            this.add(inRegisters);
        }
        if (!outSet.isEmpty()) {
            this.add(outRegisters);
        }
        for (String register2 : inSet) {
            operandMenu = new JMenu(register2);
            for (ICodeNodeExtension extension2 : extensions) {
                extension2.extendIncomingRegistersMenu(operandMenu, node, instruction, register2);
            }
            inRegisters.add(operandMenu);
        }
        for (String register2 : outSet) {
            operandMenu = new JMenu(register2);
            for (ICodeNodeExtension extension2 : extensions) {
                extension2.extendOutgoingRegistersMenu(operandMenu, node, instruction, register2);
            }
            outRegisters.add(operandMenu);
        }
    }
}

