/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CExpressionEvaluationException;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CExpressionEvaluator;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.PerspectiveType;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CGotoOperandExpressionAction;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.strings.Commafier;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import java.math.BigInteger;
import java.util.List;
import javax.swing.JPopupMenu;

public final class CFollowInDumpMenu {
    private CFollowInDumpMenu() {
    }

    private static boolean addFollowInDumpMenu(JPopupMenu menu, CDebugPerspectiveModel viewModel, IDebugger debugger, TargetProcessThread activeThread, INaviModule module, COperandTreeNode treeNode) {
        BigInteger simpleAddress = CFollowInDumpMenu.getSimpleAddress(treeNode, activeThread.getRegisterValues(), debugger, module);
        if (simpleAddress != null && CFollowInDumpMenu.needsSimpleFollowMenu(debugger, treeNode, simpleAddress)) {
            menu.add(new CGotoOperandExpressionAction(viewModel, treeNode.getValue(), simpleAddress));
            return true;
        }
        BigInteger expressionAddress = CFollowInDumpMenu.getExpressionAddress(treeNode, activeThread.getRegisterValues(), debugger, module);
        if (expressionAddress != null && !expressionAddress.equals(simpleAddress) && CFollowInDumpMenu.needsAddressExpressionMenu(debugger, treeNode, expressionAddress)) {
            INaviOperandTreeNode addressExpression = CFollowInDumpMenu.getAddressExpression(treeNode);
            menu.add(new CGotoOperandExpressionAction(viewModel, CFollowInDumpMenu.toString(addressExpression), expressionAddress));
            return true;
        }
        return false;
    }

    private static INaviOperandTreeNode getAddressExpression(INaviOperandTreeNode node) {
        Preconditions.checkNotNull(node, "IE02370: node argument can not be null");
        if (node.getType() == ExpressionType.MEMDEREF) {
            return node.getChildren().get(0);
        }
        if (node.getParent() == null) {
            throw new IllegalStateException("IE00705: Operand tree node.getParent is null");
        }
        return CFollowInDumpMenu.getAddressExpression(node.getParent());
    }

    private static BigInteger getExpressionAddress(COperandTreeNode treeNode, ImmutableList<RegisterValue> registerValues, IDebugger debugger, INaviModule module) {
        if (!CFollowInDumpMenu.isAddressExpression(treeNode)) {
            return null;
        }
        INaviOperandTreeNode addressExpression = CFollowInDumpMenu.getAddressExpression(treeNode);
        try {
            return CExpressionEvaluator.evaluateExpression(addressExpression, registerValues, debugger, module);
        }
        catch (CExpressionEvaluationException exception) {
            CUtilityFunctions.logException(exception);
            return null;
        }
    }

    private static BigInteger getSimpleAddress(COperandTreeNode treeNode, ImmutableList<RegisterValue> registerValues, IDebugger debugger, INaviModule module) {
        if (treeNode.getType() == ExpressionType.REGISTER || treeNode.getType() == ExpressionType.IMMEDIATE_INTEGER) {
            try {
                return CExpressionEvaluator.evaluateExpression(treeNode, registerValues, debugger, module);
            }
            catch (CExpressionEvaluationException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return null;
    }

    private static boolean isAddressExpression(INaviOperandTreeNode node) {
        if (node.getType() == ExpressionType.MEMDEREF) {
            return true;
        }
        return node.getParent() == null ? false : CFollowInDumpMenu.isAddressExpression(node.getParent());
    }

    private static boolean needsAddressExpressionMenu(IDebugger debugger, COperandTreeNode treeNode, BigInteger expressionAddress) {
        return CFollowInDumpMenu.isAddressExpression(treeNode) && ProcessHelpers.getSectionWith(debugger.getProcessManager().getMemoryMap(), new CAddress(expressionAddress)) != null;
    }

    private static boolean needsSimpleFollowMenu(IDebugger debugger, COperandTreeNode treeNode, BigInteger simpleAddress) {
        return treeNode.getType() == ExpressionType.REGISTER || treeNode.getType() == ExpressionType.IMMEDIATE_INTEGER && ProcessHelpers.getSectionWith(debugger.getProcessManager().getMemoryMap(), new CAddress(simpleAddress)) != null;
    }

    private static String toString(INaviOperandTreeNode node) {
        switch (node.getType()) {
            case IMMEDIATE_INTEGER: 
            case REGISTER: {
                return node.getValue();
            }
            case OPERATOR: {
                String string2 = String.valueOf(node.getValue());
                return Commafier.commafy(CFollowInDumpMenu.toString(node.getChildren()), new StringBuilder(2 + String.valueOf(string2).length()).append(" ").append(string2).append(" ").toString());
            }
        }
        throw new IllegalStateException("IE00711: This should not happen");
    }

    private static List<String> toString(List<INaviOperandTreeNode> nodes) {
        return CollectionHelpers.map(nodes, new ICollectionMapper<INaviOperandTreeNode, String>(){

            @Override
            public String map(INaviOperandTreeNode item) {
                return CFollowInDumpMenu.toString(item);
            }
        });
    }

    public static void addFollowInDumpMenu(JPopupMenu menu, CGraphModel model, NaviNode node, Object clickedObject, double y2) {
        TargetProcessThread activeThread;
        IDebugger debugger;
        Preconditions.checkNotNull(menu, "IE02371: menu argument can not be null");
        Preconditions.checkNotNull(model, "IE02372: model argument can not be null");
        Preconditions.checkNotNull(node, "IE02373: node argument can not be null");
        int line = node.positionToRow(y2);
        if (line == -1) {
            return;
        }
        INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
        INaviInstruction instruction = CCodeNodeHelpers.lineToInstruction(codeNode, line);
        if (instruction != null && (debugger = CGraphDebugger.getDebugger(model.getDebuggerProvider(), instruction)) != null && clickedObject instanceof COperandTreeNode && (activeThread = debugger.getProcessManager().getActiveThread()) != null) {
            CDebugPerspectiveModel viewModel = (CDebugPerspectiveModel)model.getGraphPanel().getViewModel().getModel(PerspectiveType.DebugPerspective);
            COperandTreeNode treeNode = (COperandTreeNode)clickedObject;
            boolean added = CFollowInDumpMenu.addFollowInDumpMenu(menu, viewModel, debugger, activeThread, instruction.getModule(), treeNode);
            if (added) {
                menu.addSeparator();
            }
        }
    }
}

