/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionShowReilCodeNode;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CChangeFunctionNameAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.COpenOriginalFunction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CRemoveFromGroupAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CMenuBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CClipboardMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CFollowInDumpMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CInliningMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CInstructionMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CIntegerOperandMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.COperandsMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.CSubFunctionMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.DeleteTypeSubstitutionMenuAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.GotoSectionAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.GotoSectionMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.GotoTypeInstanceAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.RenameTypeInstanceAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.ShowTypeInstanceReferencesAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.TypeSubstitutionAction;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.CFunctionReplacement;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CReferenceFinder;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CUnInliner;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;
import javax.swing.JPopupMenu;

public final class CCodeNodeMenu
extends JPopupMenu {
    public CCodeNodeMenu(CGraphModel model, NaviNode node, Object clickedObject, double y2, List<ICodeNodeExtension> extensions) {
        Preconditions.checkNotNull(model, "IE02368: model arguement can not be null");
        Preconditions.checkNotNull(extensions, "IE02369: extensions argument can not be null");
        Preconditions.checkNotNull(node, "IE00967: Node argument can't be null");
        int line = node.positionToRow(y2);
        INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
        INaviInstruction instruction = line != -1 ? CCodeNodeHelpers.lineToInstruction(codeNode, line) : null;
        CFollowInDumpMenu.addFollowInDumpMenu(this, model, node, clickedObject, y2);
        if (line == 0) {
            this.addRenameFunctionMenu(codeNode, model);
        }
        if (clickedObject instanceof COperandTreeNode) {
            this.addOperandTreeNodeMenu(model, (COperandTreeNode)clickedObject, node, instruction, extensions);
        }
        CMenuBuilder.addCommentMenu(this, model, node.getRawNode());
        CMenuBuilder.addSelectionMenus(this, model.getGraph(), node);
        if (node.getRawNode().getParentGroup() != null) {
            this.add(new CRemoveFromGroupAction(node));
            this.addSeparator();
        }
        this.addOpenOriginalFunctionMenu(model, node);
        boolean allowUninlining = CCodeNodeMenu.canUninline((INaviCodeNode)node.getRawNode());
        List<Pair<INaviInstruction, INaviFunction>> functions = CReferenceFinder.getCodeReferenceList((INaviCodeNode)node.getRawNode());
        this.add(new CSubFunctionMenu(model, functions, allowUninlining));
        this.add(new CInliningMenu(model, node, functions, allowUninlining));
        this.addSeparator();
        CMenuBuilder.addTaggingMenu(this, model, node);
        this.add(new CClipboardMenu(node, line));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionShowReilCodeNode(model.getParent(), (INaviCodeNode)node.getRawNode())));
        if (instruction != null) {
            this.addSeparator();
            this.add(new CInstructionMenu(model, node, instruction, extensions));
        }
    }

    private static boolean canUninline(INaviCodeNode node) {
        return CUnInliner.getInlinedNodes(node) != null;
    }

    private void addFunctionOperandMenu(CGraphModel model, INaviReplacement replacement) {
        INaviFunction function = ((CFunctionReplacement)replacement).getFunction();
        INaviView view = function.getModule().getContent().getViewContainer().getView(function);
        this.add(new CChangeFunctionNameAction(model.getParent(), view));
        this.addSeparator();
    }

    private void addImmediateOperandMenu(COperandTreeNode node, SectionContainer sections, INaviModule module) {
        this.add(new CIntegerOperandMenu(node, node.getReplacement()));
        long address = Long.parseLong(node.getValue());
        List<Section> containingSections = sections.findSections(new CAddress(address));
        if (containingSections.size() == 1) {
            this.add(new GotoSectionAction(containingSections.get(0), address, module));
        } else if (containingSections.size() > 1) {
            this.add(new GotoSectionMenu(containingSections, address, module));
        }
        this.addSeparator();
    }

    private void addInstanceReferenceMenu(CGraphModel model, COperandTreeNode treeNode) {
        INaviModule module = model.getViewContainer().getModules().get(0);
        List<TypeInstanceReference> references = treeNode.getTypeInstanceReferences();
        this.add(new ShowTypeInstanceReferencesAction(model.getParent(), references, module));
        this.add(new GotoTypeInstanceAction(references.get(0).getTypeInstance()));
        this.add(new RenameTypeInstanceAction(model.getParent(), module.getContent().getTypeInstanceContainer(), references.get(0).getTypeInstance()));
    }

    private void addOpenOriginalFunctionMenu(CGraphModel model, NaviNode node) {
        INaviCodeNode rawNode = (INaviCodeNode)node.getRawNode();
        try {
            INaviFunction nodeFunction = rawNode.getParentFunction();
            INaviFunction viewFunction = model.getViewContainer().getFunction(model.getGraph().getRawView());
            if (nodeFunction != viewFunction) {
                this.add(CActionProxy.proxy(new COpenOriginalFunction(model.getParent(), model.getViewContainer(), nodeFunction)));
            }
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }

    private void addOperandTreeNodeMenu(CGraphModel model, COperandTreeNode treeNode, NaviNode node, INaviInstruction instruction, List<ICodeNodeExtension> extensions) {
        INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
        INaviModule module = model.getViewContainer().getModules().get(0);
        if (treeNode.getType() == ExpressionType.IMMEDIATE_INTEGER && treeNode.getTypeInstanceReferences().isEmpty()) {
            this.addImmediateOperandMenu(treeNode, module.getContent().getSections(), module);
        }
        if (treeNode.getType() == ExpressionType.REGISTER) {
            this.addRegisterOperandMenu(model, treeNode, instruction, extensions, codeNode);
        }
        INaviReplacement replacement = treeNode.getReplacement();
        if (!treeNode.getTypeInstanceReferences().isEmpty() && !(replacement instanceof CFunctionReplacement)) {
            this.addInstanceReferenceMenu(model, treeNode);
        }
        if (replacement instanceof CFunctionReplacement) {
            this.addFunctionOperandMenu(model, replacement);
        }
    }

    private static BaseType getStackFrame(CGraphModel model) {
        if (model.getViewContainer().getFunction(model.getGraph().getRawView()) != null) {
            return model.getViewContainer().getFunction(model.getGraph().getRawView()).getStackFrame();
        }
        return null;
    }

    private void addRegisterOperandMenu(CGraphModel model, COperandTreeNode treeNode, INaviInstruction instruction, List<ICodeNodeExtension> extensions, INaviCodeNode codeNode) {
        try {
            this.add(new COperandsMenu(codeNode, instruction, extensions));
        }
        catch (MaybeNullException | InternalTranslationException exception) {
            CUtilityFunctions.logException(exception);
        }
        TypeManager typeManager = model.getViewContainer().getModules().get(0).getTypeManager();
        if (treeNode.getTypeSubstitution() == null) {
            this.add(TypeSubstitutionAction.instantiateCreateTypeSubstitution(model.getParent(), typeManager, CCodeNodeMenu.getStackFrame(model), treeNode));
        } else {
            this.add(new DeleteTypeSubstitutionMenuAction(typeManager, treeNode));
            this.add(TypeSubstitutionAction.instantiateEditTypeSubstitution(model.getParent(), typeManager, CCodeNodeMenu.getStackFrame(model), treeNode));
        }
        this.addSeparator();
    }

    private void addRenameFunctionMenu(INaviCodeNode codeNode, CGraphModel model) {
        try {
            INaviFunction function = codeNode.getParentFunction();
            INaviView view = function.getModule().getContent().getViewContainer().getView(function);
            this.add(new CChangeFunctionNameAction(model.getParent(), view));
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }
}

